/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.EcGost3410Signer;
import org.bouncycastle.crypto.general.EcKeyGenerationParameters;
import org.bouncycastle.crypto.general.EcKeyPairGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.encoders.Hex;

public final class ECGOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ECGOST3410", (Enum)Variations.ECGOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private ECGOST3410() {
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECGOST3410PrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(privKey.getS(), ECGOST3410.getDomainParams(privKey.getParameters().getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair kp) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair kp) {
                byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                EcGost3410Signer signer = new EcGost3410Signer();
                signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                BigInteger[] rv = signer.generateSignature(data);
                signer.init(false, kp.getPublic());
                signer.verifySignature(data, rv[0], rv[1]);
                return signer.verifySignature(data, rv[0], rv[1]);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<ECDomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<ECDomainParameters> domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public GOST3410Parameters<ECDomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final GOST3410Parameters<ECDomainParameters> parameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new EcKeyGenerationParameters(ECGOST3410.getDomainParams(this.parameters.getDomainParameters()), random);
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            ECGOST3410.validateKeyPair(kp);
            EcPublicKeyParameters pubKey = (EcPublicKeyParameters)kp.getPublic();
            EcPrivateKeyParameters prvKey = (EcPrivateKeyParameters)kp.getPrivate();
            Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey>(new AsymmetricECGOST3410PublicKey((Algorithm)algorithm, this.parameters, pubKey.getQ()), new AsymmetricECGOST3410PrivateKey((Algorithm)algorithm, this.parameters, prvKey.getD()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey key, SignatureParameters parameters) {
            EcGost3410Signer gost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricECGOST3410PrivateKey k = (AsymmetricECGOST3410PrivateKey)key;
            final EcPrivateKeyParameters privateKeyParameters = ECGOST3410.getLwKey(k);
            return new DSAOutputSigner<SignatureParameters>(gost3410Signer, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey key, SignatureParameters parameters) {
            EcGost3410Signer gost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricECGOST3410PublicKey k = (AsymmetricECGOST3410PublicKey)key;
            EcPublicKeyParameters publicKeyParameters = new EcPublicKeyParameters(k.getW(), ECGOST3410.getDomainParams((ECDomainParameters)k.getParameters().getDomainParameters()));
            gost3410Signer.init(false, publicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(gost3410Signer, digest, parameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECGOST3410;

    }
}

