/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.util.Arrays;

class ContinuousTestingEntropySource
implements EntropySource {
    private final EntropySource entropySource;
    private byte[] buf;

    public ContinuousTestingEntropySource(EntropySource entropySource) {
        this.entropySource = entropySource;
    }

    public boolean isPredictionResistant() {
        return this.entropySource.isPredictionResistant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEntropy() {
        ContinuousTestingEntropySource continuousTestingEntropySource = this;
        synchronized (continuousTestingEntropySource) {
            byte[] nxt;
            if (this.buf == null) {
                this.buf = this.entropySource.getEntropy();
            }
            if (Arrays.areEqual(nxt = this.entropySource.getEntropy(), this.buf)) {
                throw new IllegalStateException("Duplicate block detected in EntropySource output");
            }
            System.arraycopy(nxt, 0, this.buf, 0, this.buf.length);
            return nxt;
        }
    }

    public int entropySize() {
        return this.entropySource.entropySize();
    }
}

