/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KDFOperatorFactory;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.SCryptImpl;
import org.bouncycastle.util.Arrays;

public final class Scrypt {
    public static final ParametersBuilder ALGORITHM = new ParametersBuilder(new FipsAlgorithm("scrypt"));

    private Scrypt() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KDFFactory
    implements KDFOperatorFactory<Parameters> {
        @Override
        public KDFCalculator<Parameters> createKDFCalculator(final Parameters params) {
            return new KDFCalculator<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return params;
                }

                @Override
                public void generateBytes(byte[] out) {
                    byte[] tmp = SCryptImpl.generate(params.seed, params.salt, params.n, params.r, params.p, out.length);
                    System.arraycopy(tmp, 0, out, 0, out.length);
                    Arrays.fill(tmp, (byte)0);
                }

                @Override
                public void generateBytes(byte[] out, int outOff, int len) {
                    byte[] tmp = SCryptImpl.generate(params.seed, params.salt, params.n, params.r, params.p, len);
                    System.arraycopy(tmp, 0, out, outOff, len);
                    Arrays.fill(tmp, (byte)0);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        final int n;
        final int r;
        final int p;
        final byte[] salt;
        final byte[] seed;

        private Parameters(int n, byte[] seed, int r, int p, byte[] salt) {
            super(ALGORITHM.getAlgorithm());
            this.seed = seed;
            this.n = n;
            this.r = r;
            this.p = p;
            this.salt = salt;
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder(FipsAlgorithm algorithm) {
            super(algorithm);
        }

        public Parameters using(byte[] salt, int n, int r, int p, byte[] seed) {
            return new Parameters(n, Arrays.clone(seed), r, p, Arrays.clone(salt));
        }

        public Parameters using(byte[] salt, int n, int r, int p, PasswordConverter converter, char[] password) {
            return new Parameters(n, converter.convert(password), r, p, Arrays.clone(salt));
        }
    }
}

