/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputMACCalculator;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.io.MacOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FipsMACOperatorFactory<T extends AuthenticationParameters>
implements MACOperatorFactory<T> {
    FipsMACOperatorFactory() {
        FipsStatus.isReady();
    }

    @Override
    public final FipsOutputMACCalculator<T> createOutputMACCalculator(SymmetricKey key, T parameters) {
        Mac mac = this.createMAC(key, parameters);
        return new FipsOutputMACCalculator<T>((AuthenticationParameters)parameters, mac){
            final /* synthetic */ AuthenticationParameters val$parameters;
            final /* synthetic */ Mac val$mac;
            {
                this.val$parameters = authenticationParameters;
                this.val$mac = mac;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMACSize() {
                return this.val$mac.getMacSize();
            }

            @Override
            public UpdateOutputStream getMACStream() {
                return new MacOutputStream(this.val$mac);
            }

            @Override
            public int getMAC(byte[] output, int off) {
                return this.val$mac.doFinal(output, off);
            }

            @Override
            public void reset() {
                this.val$mac.reset();
            }
        };
    }

    protected abstract int calculateMACSize(T var1);

    protected abstract Mac createMAC(SymmetricKey var1, T var2);
}

