/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;

public class FipsAlgorithm
implements Algorithm {
    private final Enum basicVariation;
    private final Enum additionalVariation;
    private final String name;

    FipsAlgorithm(String name) {
        this(name, null, null);
    }

    FipsAlgorithm(String name, Enum basicVariation) {
        this(name, basicVariation, null);
    }

    FipsAlgorithm(FipsAlgorithm baseAlgorithm, Enum basicVariation) {
        this(baseAlgorithm.getName(), basicVariation, null);
    }

    FipsAlgorithm(FipsAlgorithm baseAlgorithm, Enum basicVariation, Padding additionalVariation) {
        this(baseAlgorithm.getName(), basicVariation, additionalVariation);
    }

    FipsAlgorithm(String name, Enum basicVariation, Padding additionalVariation) {
        this.basicVariation = basicVariation;
        this.additionalVariation = additionalVariation;
        this.name = basicVariation instanceof Mode ? name + "/" + ((Mode)basicVariation).getBaseMode().getCode() + (additionalVariation != null ? "/" + additionalVariation.getBasePadding().getCode() : "") : (basicVariation instanceof FipsKDF.PRF ? name + "(" + ((FipsKDF.PRF)basicVariation).getAlgorithm().getName() + ")" : (basicVariation instanceof FipsKDF.AgreementKDFPRF ? name + "(" + ((FipsKDF.AgreementKDFPRF)basicVariation).getAlgorithm().getName() + ")" : name));
    }

    Enum basicVariation() {
        return this.basicVariation;
    }

    Enum additionalVariation() {
        return this.additionalVariation;
    }

    public String getName() {
        return this.name;
    }

    public final boolean requiresAlgorithmParameters() {
        return this.basicVariation instanceof Mode && ((Mode)this.basicVariation).getBaseMode().expectsIV();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FipsAlgorithm)) {
            return false;
        }
        FipsAlgorithm other = (FipsAlgorithm)o;
        if (this.additionalVariation != null ? !this.additionalVariation.equals(other.additionalVariation) : other.additionalVariation != null) {
            return false;
        }
        if (this.basicVariation != null ? !this.basicVariation.equals(other.basicVariation) : other.basicVariation != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.additionalVariation != null ? this.additionalVariation.hashCode() : 0);
        result = 31 * result + (this.basicVariation != null ? this.basicVariation.hashCode() : 0);
        return result;
    }

    byte[] createDefaultIvIfNecessary(int blockSize, SecureRandom random) {
        return ((Mode)this.basicVariation()).createDefaultIvIfNecessary(blockSize, random);
    }

    byte[] createIvIfNecessary(int ivLen, SecureRandom random) {
        return ((Mode)this.basicVariation()).createIvIfNecessary(ivLen, random);
    }
}

