/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

public class ECDomainParametersIndex {
    public static NamedECDomainParameters lookupDomainParameters(ASN1ObjectIdentifier paramOid) {
        X9ECParameters rv = CustomNamedCurves.getByOID(paramOid);
        if (rv == null) {
            rv = ECNamedCurveTable.getByOID(paramOid);
        }
        if (rv != null) {
            return new NamedECDomainParameters(paramOid, rv.getCurve(), rv.getG(), rv.getN(), rv.getH(), rv.getSeed());
        }
        ECDomainParameters ecRV = ECGOST3410NamedCurves.getByOID(paramOid);
        if (ecRV == null) {
            ecRV = DSTU4145NamedCurves.getByOID(paramOid);
        }
        if (ecRV != null) {
            return new NamedECDomainParameters(paramOid, ecRV.getCurve(), ecRV.getG(), ecRV.getN(), ecRV.getH(), ecRV.getSeed());
        }
        return null;
    }

    public static NamedECDomainParameters lookupDomainParameters(ECDomainParametersID paramID) {
        X9ECParameters rv = CustomNamedCurves.getByName(paramID.getCurveName());
        if (rv == null) {
            rv = ECNamedCurveTable.getByName(paramID.getCurveName());
        }
        if (rv != null) {
            return new NamedECDomainParameters(ECNamedCurveTable.getOID(paramID.getCurveName()), rv.getCurve(), rv.getG(), rv.getN(), rv.getH(), rv.getSeed());
        }
        ECDomainParameters ecRV = ECGOST3410NamedCurves.getByName(paramID.getCurveName());
        if (ecRV != null) {
            return new NamedECDomainParameters(ECGOST3410NamedCurves.getOID(paramID.getCurveName()), ecRV.getCurve(), ecRV.getG(), ecRV.getN(), ecRV.getH(), ecRV.getSeed());
        }
        return null;
    }

    public static ASN1ObjectIdentifier lookupOID(ECDomainParameters domainParameters) {
        Enumeration en = ECNamedCurveTable.getNames();
        while (en.hasMoreElements()) {
            NamedECDomainParameters params;
            final String name = (String)en.nextElement();
            X9ECParameters rv = ECNamedCurveTable.getByName(name);
            if (!rv.getN().equals(domainParameters.getN()) || !((ECDomainParameters)(params = ECDomainParametersIndex.lookupDomainParameters(new ECDomainParametersID(){

                public String getCurveName() {
                    return name;
                }
            }))).equals(domainParameters)) continue;
            return ECNamedCurveTable.getOID(name);
        }
        return null;
    }
}

