/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsymmetricGOST3410Key<T>
implements AsymmetricKey {
    private Algorithm algorithm;
    protected GOST3410Parameters<T> domainParameters;

    AsymmetricGOST3410Key(Algorithm algorithm, GOST3410Parameters<T> domainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = domainParameters;
    }

    AsymmetricGOST3410Key(Algorithm algorithm, ASN1ObjectIdentifier acceptable, AlgorithmIdentifier algorithmIdentifier) {
        if (!acceptable.equals(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricGOST3410Key.decodeDomainParameters(algorithmIdentifier);
    }

    private static GOST3410Parameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            GOST3410PublicKeyAlgParameters params = GOST3410PublicKeyAlgParameters.getInstance(algorithmIdentifier.getParameters());
            return new GOST3410Parameters(params.getPublicKeyParamSet(), params.getDigestParamSet(), params.getEncryptionParamSet());
        }
        return null;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public GOST3410Parameters<T> getParameters() {
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }
}

