/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DumpInfo {
    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("-c")) {
                System.out.println(Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
                System.err.println("Generated new HMAC");
            } else if (args[0].equals("-a") && args.length > 1) {
                try {
                    JarFile jf = new JarFile(args[1]);
                    System.out.println(Strings.fromByteArray(Hex.encode(DumpInfo.calculateModuleHMAC(jf))));
                    System.err.println("Generated new HMAC for Jar file " + args[1]);
                }
                catch (IOException e) {
                    System.err.println("Unable to open Jar file " + args[1]);
                }
            } else {
                System.err.println("Invalid command line arguments.");
            }
        } else {
            System.out.println("Version Info: " + new BouncyCastleFipsProvider().getInfo());
            System.out.println("FIPS Ready Status: " + FipsStatus.getStatusMessage());
            System.out.println("Module SHA-256 HMAC: " + Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            OutputMACCalculator hMacCalculator = new FipsSHS.MACOperatorFactory().createOutputMACCalculator((SymmetricKey)new SymmetricSecretKey(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle Inc.")), FipsSHS.SHA256_HMAC);
            UpdateOutputStream mOut = hMacCalculator.getMACStream();
            TreeMap<String, Object> index = new TreeMap<String, Object>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF")) continue;
                index.put(jarEntry.getName(), jarEntry);
            }
            byte[] buf = new byte[8192];
            for (Map.Entry entry : index.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream is = jarFile.getInputStream(jarEntry);
                byte[] encName = Strings.toUTF8ByteArray(jarEntry.getName());
                mOut.update((byte)91);
                mOut.update(encName, 0, encName.length);
                mOut.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                mOut.update((byte)93);
                while ((n = is.read(buf, 0, buf.length)) != -1) {
                    mOut.update(buf, 0, n);
                }
                is.close();
            }
            mOut.update((byte)91);
            byte[] encName = Strings.toUTF8ByteArray("END");
            mOut.update(encName, 0, encName.length);
            mOut.update((byte)93);
            mOut.close();
            return hMacCalculator.getMAC();
        }
        catch (Exception e) {
            return new byte[32];
        }
    }
}

