/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.ProvIOException;

abstract class X509AlgorithmParameters
extends BaseAlgorithmParameters {
    X509AlgorithmParameters() {
    }

    protected final byte[] engineGetEncoded(String format) throws IOException {
        if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
            return this.localGetEncoded();
        }
        throw new IOException("Unknown parameter format: " + format);
    }

    protected final void engineInit(byte[] params, String format) throws IOException {
        if (params == null) {
            throw new NullPointerException("Encoded parameters cannot be null");
        }
        if (this.isASN1FormatString(format) || format.equals("X.509")) {
            try {
                this.localInit(params);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvIOException("Parameter parsing failed: " + e.getMessage(), e);
            }
        } else {
            throw new IOException("Unknown parameter format: " + format);
        }
    }
}

