/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreParameters;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertStoreCollectionSpi;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi;

class ProvPKIX
extends AsymmetricAlgorithmProvider {
    ProvPKIX() {
    }

    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new PKIXCertPathValidatorSpi(provider);
            }
        });
        provider.addAlgorithmImplementation("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new PKIXCertPathBuilderSpi(provider);
            }
        });
        provider.addAlgorithmImplementation("CertStore.COLLECTION", "org.bouncycastle.jce.provider.CertStoreCollectionSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                try {
                    return new CertStoreCollectionSpi((CertStoreParameters)constructorParameter);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new NoSuchAlgorithmException("Unable to construct CertStore implementation: " + e.getMessage(), e);
                }
            }
        });
    }
}

