/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.MessageDigest;
import org.bouncycastle.crypto.OutputDigestCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;

final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    private final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters algorithm) {
        this(fipsFactory.createOutputDigestCalculator(algorithm));
    }

    BaseMessageDigest(OutputDigestCalculator digestCalculator) {
        super(((Parameters)digestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = digestCalculator;
        this.digestStream = digestCalculator.getDigestStream();
    }

    protected void engineReset() {
        this.digestCalculator.reset();
    }

    protected void engineUpdate(byte input) {
        this.digestStream.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.digestStream.update(input, offset, len);
    }

    protected byte[] engineDigest() {
        byte[] digestBytes = this.digestCalculator.getDigest();
        this.engineReset();
        return digestBytes;
    }

    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

