/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.ContinuousTestingEntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.fips.DRBGProvider;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;

class DRBGPseudoRandom
implements DRBG {
    private final FipsAlgorithm algorithm;
    private final DRBGProvider drbgProvider;
    private final EntropySource entropySource;
    private DRBG drbg;

    DRBGPseudoRandom(FipsAlgorithm algorithm, EntropySource entropySource, DRBGProvider drbgProvider) {
        this.algorithm = algorithm;
        this.entropySource = new ContinuousTestingEntropySource(entropySource);
        this.drbgProvider = drbgProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockSize() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSecurityStrength() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getSecurityStrength();
        }
    }

    private void lazyInitDRBG() {
        if (this.drbg == null) {
            this.drbg = this.drbgProvider.get(this.entropySource);
            SelfTestExecutor.validate(this.algorithm, this.drbg.createSelfTest(this.algorithm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            if (predictionResistant) {
                SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
            }
            if (this.drbg.generate(output, additionalInput, predictionResistant) < 0) {
                SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
                this.drbg.reseed(null);
                return this.drbg.generate(output, additionalInput, predictionResistant);
            }
            return output.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reseed(byte[] additionalInput) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
            this.drbg.reseed(additionalInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariantInternalKatTest createSelfTest(FipsAlgorithm algorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createSelfTest(algorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm algorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createReseedSelfTest(algorithm);
        }
    }
}

