/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricRSAPrivateKey
extends AsymmetricRSAKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private BigInteger dp;
    private BigInteger dq;
    private BigInteger qInv;
    private int hashCode;

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dp, BigInteger dq, BigInteger qInv) {
        super(algorithm, modulus);
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.p = p;
        this.q = q;
        this.dp = dp;
        this.dq = dq;
        this.qInv = qInv;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger modulus, BigInteger privateExponent) {
        super(algorithm, modulus);
        this.privateExponent = privateExponent;
        this.publicExponent = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.q = BigInteger.ZERO;
        this.dp = BigInteger.ZERO;
        this.dq = BigInteger.ZERO;
        this.qInv = BigInteger.ZERO;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, byte[] privateKeyInfoEncoding) {
        this(algorithm, AsymmetricRSAPrivateKey.getPrivateKeyInfo(privateKeyInfoEncoding));
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricRSAPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private static PrivateKeyInfo getPrivateKeyInfo(byte[] encoding) {
        try {
            return PrivateKeyInfo.getInstance(encoding);
        }
        catch (IllegalArgumentException e) {
            try {
                return new PrivateKeyInfo(DEF_ALG_ID, ASN1Sequence.getInstance(encoding));
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Unable to parse private key: " + e.getMessage(), e);
            }
        }
    }

    private static RSAPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse private key: " + e.getMessage(), e);
        }
    }

    private AsymmetricRSAPrivateKey(Algorithm algorithm, AlgorithmIdentifier algId, RSAPrivateKey privKey) {
        super(algorithm, algId, KeyUtils.validatedModulus(privKey.getModulus()));
        this.publicExponent = privKey.getPublicExponent();
        this.privateExponent = privKey.getPrivateExponent();
        this.p = privKey.getPrime1();
        this.q = privKey.getPrime2();
        this.dp = privKey.getExponent1();
        this.dq = privKey.getExponent2();
        this.qInv = privKey.getCoefficient();
        this.hashCode = this.calculateHashCode();
    }

    public Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public BigInteger getModulus() {
        KeyUtils.checkDestroyed(this);
        return super.getModulus();
    }

    public BigInteger getPublicExponent() {
        KeyUtils.checkDestroyed(this);
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        this.checkCanRead();
        return this.privateExponent;
    }

    public BigInteger getP() {
        this.checkCanRead();
        return this.p;
    }

    public BigInteger getQ() {
        this.checkCanRead();
        return this.q;
    }

    public BigInteger getDP() {
        this.checkCanRead();
        return this.dp;
    }

    public BigInteger getDQ() {
        this.checkCanRead();
        return this.dq;
    }

    public BigInteger getQInv() {
        this.checkCanRead();
        return this.qInv;
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return KeyUtils.getEncodedPrivateKeyInfo(this.rsaAlgIdentifier, new RSAPrivateKey(this.getModulus(), this.publicExponent, this.getPrivateExponent(), this.getP(), this.getQ(), this.getDP(), this.getDQ(), this.getQInv()));
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.publicExponent = null;
            this.privateExponent = null;
            this.qInv = null;
            this.dq = null;
            this.dp = null;
            this.q = null;
            this.p = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricRSAPrivateKey)) {
            return false;
        }
        AsymmetricRSAPrivateKey other = (AsymmetricRSAPrivateKey)o;
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        return this.getModulus().equals(other.getModulus()) && this.privateExponent.equals(other.privateExponent) && this.getPublicExponent().equals(other.getPublicExponent()) && this.p.equals(other.p) && this.q.equals(other.q) && this.dp.equals(other.dp) && this.dq.equals(other.dq) && this.qInv.equals(other.qInv);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getModulus().hashCode();
        result = 31 * result + this.publicExponent.hashCode();
        result = 31 * result + this.privateExponent.hashCode();
        result = 31 * result + this.p.hashCode();
        result = 31 * result + this.q.hashCode();
        result = 31 * result + this.dp.hashCode();
        result = 31 * result + this.dq.hashCode();
        result = 31 * result + this.qInv.hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    private void checkCanRead() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
    }
}

