/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.Arrays;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.internal.Permissions;

public final class SymmetricSecretKey
implements SymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;

    public SymmetricSecretKey(Algorithm algorithm, byte[] bytes) {
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])bytes.clone();
    }

    public SymmetricSecretKey(Parameters parameterSet, byte[] bytes) {
        this.algorithm = parameterSet.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])bytes.clone();
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    private void zeroize() {
        for (int i = 0; i != this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        return (byte[])this.bytes.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey other = (SymmetricSecretKey)o;
        if (!this.getAlgorithm().equals(other.getAlgorithm())) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }
}

