/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.feature.TupleDesc_U8;
import boofcv.struct.kmeans.ComputeMeanTuple_U8;
import java.util.Arrays;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;
import pabeles.concurrency.GrowArray;

public class ComputeMeanTuple_MT_U8
extends ComputeMeanTuple_U8 {
    int minimumForConcurrent = 0;
    final int tupleDof;
    GrowArray<ThreadData> threadData;

    public ComputeMeanTuple_MT_U8(int numElements) {
        super(numElements);
        this.tupleDof = numElements;
        this.threadData = new GrowArray(() -> new ThreadData());
    }

    @Override
    public void process(LArrayAccessor<TupleDesc_U8> points, DogArray_I32 assignments, FastAccess<TupleDesc_U8> clusters) {
        int i;
        if (points.size() < this.minimumForConcurrent) {
            super.process(points, assignments, clusters);
            return;
        }
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        BoofConcurrency.loopBlocks((int)0, (int)points.size(), this.threadData, (data, idx0, idx1) -> {
            TupleDesc_U8 tuple = data.point;
            DogArray<int[]> sums = data.clusterSums;
            sums.resize(clusters.size);
            for (int i = 0; i < sums.size; ++i) {
                Arrays.fill(((int[][])sums.data)[i], 0);
            }
            DogArray_I32 counts = data.counts;
            counts.resize(sums.size, 0);
            for (int pointIdx = idx0; pointIdx < idx1; ++pointIdx) {
                int clusterIdx;
                points.getCopy(pointIdx, (Object)tuple);
                byte[] point = tuple.data;
                int n = clusterIdx = assignments.get(pointIdx);
                counts.data[n] = counts.data[n] + 1;
                int[] sum = (int[])sums.get(clusterIdx);
                for (int i = 0; i < point.length; ++i) {
                    int n2 = i;
                    sum[n2] = sum[n2] + (point[i] & 0xFF);
                }
            }
        });
        this.counts.reset();
        this.counts.resize(clusters.size, 0);
        this.means.resize(clusters.size);
        for (int i2 = 0; i2 < clusters.size; ++i2) {
            Arrays.fill(((int[][])this.means.data)[i2], 0);
        }
        for (int threadIdx = 0; threadIdx < this.threadData.size(); ++threadIdx) {
            ThreadData data2 = (ThreadData)this.threadData.get(threadIdx);
            for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
                int[] a = (int[])data2.clusterSums.get(clusterIdx);
                int[] b = (int[])this.means.get(clusterIdx);
                for (i = 0; i < b.length; ++i) {
                    int n = i;
                    b[n] = b[n] + a[i];
                }
                int n = clusterIdx;
                this.counts.data[n] = this.counts.data[n] + data2.counts.data[clusterIdx];
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            int[] sum = (int[])this.means.get(clusterIdx);
            byte[] cluster = ((TupleDesc_U8)clusters.get((int)clusterIdx)).data;
            double divisor = this.counts.get(clusterIdx);
            for (i = 0; i < cluster.length; ++i) {
                cluster[i] = (byte)((double)sum[i] / divisor);
            }
        }
    }

    @Override
    public ComputeMeanClusters<TupleDesc_U8> newInstanceThread() {
        return new ComputeMeanTuple_MT_U8(this.tupleDof);
    }

    public int getMinimumForConcurrent() {
        return this.minimumForConcurrent;
    }

    public void setMinimumForConcurrent(int minimumForConcurrent) {
        this.minimumForConcurrent = minimumForConcurrent;
    }

    class ThreadData {
        TupleDesc_U8 point;
        DogArray_I32 counts;
        DogArray<int[]> clusterSums;

        ThreadData() {
            this.point = new TupleDesc_U8(ComputeMeanTuple_MT_U8.this.tupleDof);
            this.counts = new DogArray_I32();
            this.clusterSums = new DogArray(() -> new int[ComputeMeanTuple_MT_U8.this.tupleDof]);
        }
    }
}

