/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.template;

import boofcv.alg.template.TemplateIntensityImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import java.util.Objects;

public abstract class TemplateSumAbsoluteDifference<T extends ImageBase<T>>
implements TemplateIntensityImage.EvaluatorMethod<T> {
    TemplateIntensityImage<T> o;

    @Override
    public void initialize(TemplateIntensityImage<T> owner) {
        this.o = owner;
    }

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    @Override
    public boolean isMaximize() {
        return false;
    }

    public static class U8
    extends TemplateSumAbsoluteDifference<GrayU8> {
        @Override
        public float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    rowTotal += Math.abs((((GrayU8)this.o.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.o.template).data[templateIndex++] & 0xFF));
                }
                total += (float)rowTotal;
            }
            return total;
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            Objects.requireNonNull((GrayU8)this.o.mask);
            float total = 0.0f;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                int maskIndex = ((GrayU8)this.o.mask).startIndex + y * ((GrayU8)this.o.mask).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    int m = ((GrayU8)this.o.mask).data[maskIndex++] & 0xFF;
                    rowTotal += m * Math.abs((((GrayU8)this.o.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.o.template).data[templateIndex++] & 0xFF));
                }
                total += (float)rowTotal;
            }
            return total;
        }
    }

    public static class F32
    extends TemplateSumAbsoluteDifference<GrayF32> {
        @Override
        public float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                float rowTotal = 0.0f;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    rowTotal += Math.abs(((GrayF32)this.o.image).data[imageIndex++] - ((GrayF32)this.o.template).data[templateIndex++]);
                }
                total += rowTotal;
            }
            return total;
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            Objects.requireNonNull((GrayF32)this.o.mask);
            float total = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                int maskIndex = ((GrayF32)this.o.mask).startIndex + y * ((GrayF32)this.o.mask).stride;
                float rowTotal = 0.0f;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    rowTotal += ((GrayF32)this.o.mask).data[maskIndex++] * Math.abs(((GrayF32)this.o.image).data[imageIndex++] - ((GrayF32)this.o.template).data[templateIndex++]);
                }
                total += rowTotal;
            }
            return total;
        }
    }
}

