/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.alg.drawing.FiducialImageGenerator;
import boofcv.factory.fiducial.ConfigHammingMarker;

public class FiducialSquareHammingGenerator
extends FiducialImageGenerator {
    public double offsetX;
    public double offsetY;
    final ConfigHammingMarker config;

    public FiducialSquareHammingGenerator(ConfigHammingMarker config) {
        this.config = config;
    }

    public void generate(int markerIdx) {
        this.renderer.init();
        this.generateNoInit(markerIdx);
    }

    public void generateNoInit(int markerIdx) {
        ConfigHammingMarker.Marker shape = (ConfigHammingMarker.Marker)this.config.encoding.get(markerIdx);
        this.renderBorder();
        this.renderCodes(shape);
    }

    private void renderBorder() {
        this.renderer.setGray(0.0);
        double bw = this.config.borderWidthFraction * this.markerWidth;
        this.renderer.square(this.offsetX, this.offsetY, this.markerWidth, bw);
    }

    public void renderCodes(ConfigHammingMarker.Marker marker) {
        int rows = this.config.gridWidth;
        int cols = this.config.gridWidth;
        this.renderer.setGray(0.0);
        double bw = this.config.borderWidthFraction * this.markerWidth;
        double bit = (this.markerWidth - 2.0 * bw) / (double)this.config.gridWidth;
        int bitIndex = 0;
        for (int row = 0; row < rows; ++row) {
            double y0 = this.offsetY + bw + (double)(rows - row - 1) * bit;
            double y1 = this.offsetY + bw + (double)(rows - row) * bit;
            for (int col = 0; col < cols; ++col) {
                double x0 = this.offsetX + bw + (double)(cols - col - 1) * bit;
                double x1 = this.offsetX + bw + (double)(cols - col) * bit;
                if (marker.pattern.get(bitIndex++) == 1) continue;
                this.renderer.rectangle(x0, y0, x1, y1);
            }
        }
    }

    public ConfigHammingMarker getConfig() {
        return this.config;
    }
}

