/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecEncoderAutomatic;
import boofcv.alg.fiducial.aztec.AztecMessageErrorCorrection;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.misc.BoofMiscOps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray_I8;

public class AztecEncoder
extends AztecMessageErrorCorrection {
    AztecCode workMarker = new AztecCode();
    PackedBits8 bits = new PackedBits8();
    AztecEncoderAutomatic automatic = new AztecEncoderAutomatic();
    public double errorCorrectionLength = 0.77;
    private final List<MessageSegment> segments = new ArrayList<MessageSegment>();

    public AztecEncoder() {
        this.reset();
    }

    public void reset() {
        this.workMarker.reset();
        this.workMarker.structure = AztecCode.Structure.FULL;
        this.workMarker.dataLayers = -1;
        this.segments.clear();
    }

    public AztecEncoder setEcc(double fraction) {
        this.errorCorrectionLength = fraction;
        return this;
    }

    public AztecEncoder setStructure(AztecCode.Structure structure) {
        this.workMarker.structure = structure;
        return this;
    }

    public AztecEncoder setLayers(int numLayers) {
        this.workMarker.dataLayers = numLayers;
        return this;
    }

    public AztecEncoder addUpper(String message) {
        message = message.toUpperCase();
        DogArray_I8 values = new DogArray_I8(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == ' ') {
                values.add(1);
                continue;
            }
            int value = c - 65;
            if (value >= 26) {
                throw new IllegalArgumentException("Only space and letters in the alphabet are allowed, not '" + c + "'");
            }
            values.add((int)((char)(value + 2)));
        }
        this.segments.add(new MessageSegment(AztecCode.Mode.UPPER, values, message));
        return this;
    }

    public AztecEncoder addLower(String message) {
        message = message.toLowerCase();
        DogArray_I8 values = new DogArray_I8(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == ' ') {
                values.add(1);
                continue;
            }
            int value = c - 97;
            if (value >= 26) {
                throw new IllegalArgumentException("Only space and letters in the alphabet are allowed, not '" + c + "'");
            }
            values.add((int)((char)(value + 2)));
        }
        this.segments.add(new MessageSegment(AztecCode.Mode.LOWER, values, message));
        return this;
    }

    public AztecEncoder addMixed(String message) {
        byte[] ascii = message.getBytes(StandardCharsets.US_ASCII);
        DogArray_I8 values = new DogArray_I8(ascii.length);
        for (int i = 0; i < ascii.length; ++i) {
            int v = ascii[i] % 255;
            if (v == 32) {
                values.add(1);
                continue;
            }
            if (v >= 1 && v <= 13) {
                values.add((int)((byte)(v + 1)));
                continue;
            }
            if (v >= 27 && v <= 31) {
                values.add((int)((byte)(v - 27 + 15)));
                continue;
            }
            if (v == 64) {
                values.add(20);
                continue;
            }
            if (v == 92) {
                values.add(21);
                continue;
            }
            if (v >= 94 && v <= 96) {
                values.add((int)((byte)(v - 94 + 22)));
                continue;
            }
            if (v == 124) {
                values.add(25);
                continue;
            }
            if (v == 126) {
                values.add(26);
                continue;
            }
            if (v == 127) {
                values.add(27);
                continue;
            }
            throw new IllegalArgumentException("Invalid ascii " + v);
        }
        this.segments.add(new MessageSegment(AztecCode.Mode.MIXED, values, message));
        return this;
    }

    public AztecEncoder addPunctuation(String message) {
        DogArray_I8 values = new DogArray_I8(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char a = message.charAt(i);
            if (i + 1 < message.length()) {
                char b = message.charAt(i + 1);
                boolean matched = true;
                if (a == '\r' && b == '\n') {
                    values.add(2);
                } else if (b == ' ') {
                    if (a == '.') {
                        values.add(3);
                    } else if (a == ',') {
                        values.add(4);
                    } else if (a == ':') {
                        values.add(5);
                    } else {
                        matched = false;
                    }
                } else {
                    matched = false;
                }
                if (matched) {
                    ++i;
                    continue;
                }
            }
            if (a == '\r') {
                values.add(1);
                continue;
            }
            if (a >= '!' && a <= '/') {
                values.add(a - 33 + 6);
                continue;
            }
            if (a >= ':' && a <= ';') {
                values.add(a - 58 + 21);
                continue;
            }
            if (a >= '<' && a <= '?') {
                values.add(a - 60 + 23);
                continue;
            }
            if (a == '[') {
                values.add(27);
                continue;
            }
            if (a == ']') {
                values.add(28);
                continue;
            }
            if (a == '{') {
                values.add(29);
                continue;
            }
            if (a == '}') {
                values.add(30);
                continue;
            }
            throw new IllegalArgumentException("Invalid ascii " + a);
        }
        this.segments.add(new MessageSegment(AztecCode.Mode.PUNCT, values, message));
        return this;
    }

    public AztecEncoder addDigit(String message) {
        DogArray_I8 values = new DogArray_I8(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == ' ') {
                values.add(1);
                continue;
            }
            if (c >= '0' && c <= '9') {
                values.add(c - 48 + 2);
                continue;
            }
            if (c == ',') {
                values.add(12);
                continue;
            }
            if (c != '.') continue;
            values.add(13);
        }
        this.segments.add(new MessageSegment(AztecCode.Mode.DIGIT, values, message));
        return this;
    }

    public AztecEncoder addBytes(byte[] data, int offset, int length) {
        DogArray_I8 values = new DogArray_I8(length);
        values.size = length;
        System.arraycopy(data, offset, values.data, 0, length);
        this.segments.add(new MessageSegment(AztecCode.Mode.BYTE, values, new String(data, offset, length, StandardCharsets.ISO_8859_1)));
        return this;
    }

    public AztecEncoder addAutomatic(String message) {
        this.automatic.process(message, this);
        return this;
    }

    public AztecCode fixate() {
        this.segmentsToEncodedBits();
        this.selectNumberOfLayers();
        this.bitsToWords();
        this.computeEccWords(this.workMarker.getWordBitCount(), this.workMarker.getCapacityWords());
        return this.copyIntoResults();
    }

    void segmentsToEncodedBits() {
        AztecCode.Mode currentMode = AztecCode.Mode.UPPER;
        for (int segIdx = 0; segIdx < this.segments.size(); ++segIdx) {
            MessageSegment m = this.segments.get(segIdx);
            boolean latched = this.transitionIntoMode(currentMode, m);
            switch (m.encodingMode) {
                case UPPER: {
                    this.append(m.data, 5);
                    break;
                }
                case LOWER: {
                    this.append(m.data, 5);
                    break;
                }
                case MIXED: {
                    this.append(m.data, 5);
                    break;
                }
                case PUNCT: {
                    this.append(m.data, 5);
                    break;
                }
                case DIGIT: {
                    this.append(m.data, 4);
                    break;
                }
                case BYTE: {
                    this.appendByteArray(m.data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Encoding not yet supported: " + m.encodingMode);
                }
            }
            this.workMarker.message = this.workMarker.message + m.message;
            if (!latched) continue;
            currentMode = m.encodingMode;
        }
    }

    void bitsToWords() {
        int wordBitCount = this.workMarker.getWordBitCount();
        int ones = (1 << wordBitCount) - 1;
        int onesMinusOne = ones - 1;
        this.storageDataWords.reset();
        int bitLocation = 0;
        while (bitLocation + wordBitCount <= this.bits.size) {
            short word = (short)this.bits.read(bitLocation, wordBitCount, true);
            if (word == 0) {
                this.storageDataWords.add(1);
                bitLocation += wordBitCount - 1;
            } else if (word == (short)ones) {
                this.storageDataWords.add(onesMinusOne);
                bitLocation += wordBitCount - 1;
            } else {
                this.storageDataWords.add((int)word);
                bitLocation += wordBitCount;
            }
            if (word != 1 && word != onesMinusOne) continue;
            --bitLocation;
        }
        if (this.bits.size > bitLocation) {
            int readBits = this.bits.size - bitLocation;
            int word = this.bits.read(bitLocation, readBits, true);
            int remainder = wordBitCount - readBits;
            if ((word = word << remainder | 65535 >> 16 - remainder) == ones) {
                word = onesMinusOne;
            }
            this.storageDataWords.add(word);
        }
        this.workMarker.messageWordCount = this.storageDataWords.size;
        if (this.workMarker.messageWordCount > this.workMarker.getCapacityWords()) {
            throw new RuntimeException("Encoded message is larger than the capacity. Increase number of layers if manual or report a bug if automatic");
        }
    }

    void selectNumberOfLayers() {
        if (this.workMarker.dataLayers > 0) {
            return;
        }
        int targetBits = (int)((double)this.bits.size * (1.0 + this.errorCorrectionLength));
        int maxLayers = this.workMarker.structure.maxDataLayers;
        int maxPossibleBits = this.workMarker.structure.getCapacityBits(maxLayers);
        if (targetBits > maxPossibleBits) {
            if (this.bits.size <= maxPossibleBits) {
                throw new IllegalArgumentException("Too large with ECC level. Try reducing amount of ECC");
            }
            throw new IllegalArgumentException("Too large to be encoded inside a single marker");
        }
        for (int layers = 1; layers <= maxLayers; ++layers) {
            int capacityBits = this.workMarker.structure.getCapacityBits(layers);
            if (capacityBits < targetBits) continue;
            this.workMarker.dataLayers = layers;
            break;
        }
    }

    AztecCode copyIntoResults() {
        AztecCode results = new AztecCode().setTo(this.workMarker);
        int wordBitCount = this.workMarker.getWordBitCount();
        this.bits.resize(0);
        for (int wordIdx = 0; wordIdx < this.storageDataWords.size; ++wordIdx) {
            this.bits.append(this.storageDataWords.get(wordIdx) & 0xFFFF, wordBitCount, false);
        }
        this.bits.size = this.storageDataWords.size * wordBitCount;
        results.corrected = new byte[BoofMiscOps.bitToByteCount((int)this.bits.size)];
        System.arraycopy(this.bits.data, 0, results.corrected, 0, results.corrected.length);
        for (int word = 0; word < this.storageEccWords.size; ++word) {
            this.bits.append(this.storageEccWords.get(word) & 0xFFFF, wordBitCount, false);
        }
        results.rawbits = new byte[BoofMiscOps.bitToByteCount((int)this.bits.size)];
        System.arraycopy(this.bits.data, 0, results.rawbits, 0, results.rawbits.length);
        return results;
    }

    private boolean transitionIntoMode(AztecCode.Mode currentMode, MessageSegment m) {
        boolean latched = true;
        block0 : switch (currentMode) {
            case UPPER: {
                switch (m.encodingMode) {
                    case UPPER: {
                        break block0;
                    }
                    case LOWER: {
                        this.append(28, 5);
                        break block0;
                    }
                    case MIXED: {
                        this.append(29, 5);
                        break block0;
                    }
                    case DIGIT: {
                        this.append(30, 5);
                        break block0;
                    }
                    case BYTE: {
                        this.append(31, 5);
                        latched = false;
                        break block0;
                    }
                    case PUNCT: {
                        if (m.data.size == 1) {
                            this.append(0, 5);
                            latched = false;
                            break block0;
                        }
                        this.append(29, 5);
                        this.append(30, 5);
                        break block0;
                    }
                }
                AztecEncoder.throwUnsupported(currentMode, m.encodingMode);
                break;
            }
            case LOWER: {
                switch (m.encodingMode) {
                    case LOWER: {
                        break block0;
                    }
                    case UPPER: {
                        this.append(28, 5);
                        latched = false;
                        break block0;
                    }
                    case MIXED: {
                        this.append(29, 5);
                        break block0;
                    }
                    case DIGIT: {
                        this.append(30, 5);
                        break block0;
                    }
                    case BYTE: {
                        this.append(31, 5);
                        latched = false;
                        break block0;
                    }
                    case PUNCT: {
                        if (m.data.size == 1) {
                            this.append(0, 5);
                            latched = false;
                            break block0;
                        }
                        this.append(29, 5);
                        this.append(30, 5);
                        break block0;
                    }
                }
                AztecEncoder.throwUnsupported(currentMode, m.encodingMode);
                break;
            }
            case MIXED: {
                switch (m.encodingMode) {
                    case MIXED: {
                        break block0;
                    }
                    case LOWER: {
                        this.append(28, 5);
                        break block0;
                    }
                    case UPPER: {
                        this.append(29, 5);
                        break block0;
                    }
                    case PUNCT: {
                        if (m.data.size == 1) {
                            this.append(0, 5);
                            latched = false;
                            break block0;
                        }
                        this.append(30, 5);
                        break block0;
                    }
                    case DIGIT: {
                        this.append(29, 5);
                        this.append(30, 5);
                        break block0;
                    }
                    case BYTE: {
                        this.append(31, 5);
                        latched = false;
                        break block0;
                    }
                }
                AztecEncoder.throwUnsupported(currentMode, m.encodingMode);
                break;
            }
            case PUNCT: {
                switch (m.encodingMode) {
                    case PUNCT: {
                        break block0;
                    }
                    case LOWER: {
                        this.append(31, 5);
                        this.append(28, 5);
                        break block0;
                    }
                    case UPPER: {
                        this.append(31, 5);
                        break block0;
                    }
                    case MIXED: {
                        this.append(31, 5);
                        this.append(29, 5);
                        break block0;
                    }
                    case DIGIT: {
                        this.append(31, 5);
                        this.append(30, 5);
                        break block0;
                    }
                    case BYTE: {
                        this.append(31, 5);
                        this.append(31, 5);
                        latched = false;
                        break block0;
                    }
                }
                AztecEncoder.throwUnsupported(currentMode, m.encodingMode);
                break;
            }
            case DIGIT: {
                switch (m.encodingMode) {
                    case DIGIT: {
                        break block0;
                    }
                    case LOWER: {
                        this.append(14, 4);
                        this.append(28, 5);
                        break block0;
                    }
                    case UPPER: {
                        if (m.data.size == 1) {
                            latched = false;
                            this.append(15, 4);
                            break block0;
                        }
                        this.append(14, 4);
                        break block0;
                    }
                    case PUNCT: {
                        if (m.data.size == 1) {
                            this.append(0, 4);
                            latched = false;
                            break block0;
                        }
                        this.append(14, 4);
                        this.append(29, 5);
                        this.append(30, 5);
                        break block0;
                    }
                    case MIXED: {
                        this.append(14, 4);
                        this.append(29, 5);
                        break block0;
                    }
                    case BYTE: {
                        this.append(14, 4);
                        this.append(31, 5);
                        latched = false;
                        break block0;
                    }
                }
                AztecEncoder.throwUnsupported(currentMode, m.encodingMode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported. current=" + currentMode + " encoding=" + m.encodingMode);
            }
        }
        return latched;
    }

    private void append(int value, int wordBits) {
        this.bits.append(value, wordBits, false);
    }

    private void append(DogArray_I8 message, int wordBits) {
        for (int i = 0; i < message.size; ++i) {
            this.bits.append(message.data[i] & 0xFF, wordBits, false);
        }
    }

    private void appendByteArray(DogArray_I8 message) {
        if (message.size < 32) {
            this.bits.append(message.size, 5, false);
        } else if (message.size < 2078) {
            this.bits.append(0, 5, false);
            this.bits.append(message.size - 31, 11, false);
        } else {
            throw new IllegalArgumentException("Message is too long to be encoded: " + message.size);
        }
        this.bits.append(message.data, message.size * 8, false);
    }

    private static int throwUnsupported(AztecCode.Mode src, AztecCode.Mode dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can't transition from " + src + " to " + dst);
    }

    public static class MessageSegment {
        public AztecCode.Mode encodingMode;
        public DogArray_I8 data;
        public String message;

        public MessageSegment(AztecCode.Mode encodingMode, DogArray_I8 data, String message) {
            this.encodingMode = encodingMode;
            this.data = data;
            this.message = message;
        }
    }
}

