/*
 * Copyright (c) 2022, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.struct.kmeans;

import javax.annotation.Generated;
import boofcv.struct.feature.TupleDesc_F32;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

/**
 * Update cluster assignments for {@link TupleDesc_F32} descriptors.
 *
 * @author Peter Abeles
 */
@Generated("boofcv.struct.kmeans.ComputeMeanTuple_F64")
public class ComputeMeanTuple_F32 implements ComputeMeanClusters<TupleDesc_F32> {
	DogArray_I32 counts = new DogArray_I32();

	@Override public void process( LArrayAccessor<TupleDesc_F32> points,
								   DogArray_I32 assignments,
								   FastAccess<TupleDesc_F32> clusters) {

		if (assignments.size != points.size())
			throw new IllegalArgumentException("Points and assignments need to be the same size");

		// set the number of points in each cluster to zero and zero the clusters
		counts.reset().resize(clusters.size, 0);
		for (int i = 0; i < clusters.size; i++) {
			clusters.get(i).fill(0.0f);
		}

		// Compute the sum of all points in each cluster
		for (int pointIdx = 0; pointIdx < points.size(); pointIdx++) {
			float[] point = points.getTemp(pointIdx).data;

			int clusterIdx = assignments.get(pointIdx);
			counts.data[clusterIdx]++;
			float[] cluster = clusters.get(clusterIdx).data;
			for (int i = 0; i < point.length; i++) {
				cluster[i] += point[i];
			}
		}

		// Divide to get the average value in each cluster
		for (int clusterIdx = 0; clusterIdx < clusters.size; clusterIdx++) {
			float[] cluster = clusters.get(clusterIdx).data;
			float divisor = counts.get(clusterIdx);
			for (int i = 0; i < cluster.length; i++) {
				cluster[i] /= divisor;
			}
		}
	}

	@Override public ComputeMeanClusters<TupleDesc_F32> newInstanceThread() {
		return new ComputeMeanTuple_F32();
	}
}
