/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.nio.ByteBuffer;
import org.ddogleg.struct.DogArray_I8;

public class ConvertByteBufferImage {
    public static void from_3BU8_to_U8(ByteBuffer src, int srcOffset, int srcStride, GrayU8 dst, DogArray_I8 work) {
        work.resize(dst.width * 3);
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(work.data, 0, work.size);
            int indexDst = dst.startIndex + dst.stride * y;
            int i = 0;
            while (i < work.size) {
                int r = work.data[i++] & 0xFF;
                int g = work.data[i++] & 0xFF;
                int b = work.data[i++] & 0xFF;
                int ave = (r + g + b) / 3;
                dst.data[indexDst++] = (byte)ave;
            }
            indexSrc += srcStride;
        }
    }

    public static void from_3BU8_to_3PU8(ByteBuffer src, int srcOffset, int srcStride, Planar<GrayU8> dst, DogArray_I8 work) {
        work.resize(dst.width * 3);
        GrayU8 r = (GrayU8)dst.getBand(0);
        GrayU8 g = (GrayU8)dst.getBand(1);
        GrayU8 b = (GrayU8)dst.getBand(2);
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(work.data, 0, work.size);
            int indexDst = dst.startIndex + dst.stride * y;
            int i = 0;
            while (i < work.size) {
                r.data[indexDst] = work.data[i++];
                g.data[indexDst] = work.data[i++];
                b.data[indexDst] = work.data[i++];
                ++indexDst;
            }
            indexSrc += srcStride;
        }
    }

    public static void from_3BU8_to_3IU8(ByteBuffer src, int srcOffset, int srcStride, InterleavedU8 dst) {
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(dst.data, 0, dst.width * 3);
            indexSrc += srcStride;
        }
    }

    public static void from_3BU8_to_F32(ByteBuffer src, int srcOffset, int srcStride, GrayF32 dst, DogArray_I8 work) {
        work.resize(dst.width * 3);
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(work.data, 0, work.size);
            int indexDst = dst.startIndex + dst.stride * y;
            int i = 0;
            while (i < work.size) {
                int r = work.data[i++] & 0xFF;
                int g = work.data[i++] & 0xFF;
                int b = work.data[i++] & 0xFF;
                int ave = (r + g + b) / 3;
                dst.data[indexDst++] = ave;
            }
            indexSrc += srcStride;
        }
    }

    public static void from_3BU8_to_3PF32(ByteBuffer src, int srcOffset, int srcStride, Planar<GrayF32> dst, DogArray_I8 work) {
        work.resize(dst.width * 3);
        GrayF32 r = (GrayF32)dst.getBand(0);
        GrayF32 g = (GrayF32)dst.getBand(1);
        GrayF32 b = (GrayF32)dst.getBand(2);
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(work.data, 0, work.size);
            int indexDst = dst.startIndex + dst.stride * y;
            int i = 0;
            while (i < work.size) {
                r.data[indexDst] = work.data[i++] & 0xFF;
                g.data[indexDst] = work.data[i++] & 0xFF;
                b.data[indexDst] = work.data[i++] & 0xFF;
                ++indexDst;
            }
            indexSrc += srcStride;
        }
    }

    public static void from_3BU8_to_3IF32(ByteBuffer src, int srcOffset, int srcStride, InterleavedF32 dst, DogArray_I8 work) {
        work.resize(dst.width * 3);
        int indexSrc = srcOffset;
        for (int y = 0; y < dst.height; ++y) {
            src.position(indexSrc);
            src.get(work.data, 0, work.size);
            int indexDst = dst.startIndex + dst.stride * y;
            int i = 0;
            while (i < work.size) {
                dst.data[indexDst++] = work.data[i++] & 0xFF;
                dst.data[indexDst++] = work.data[i++] & 0xFF;
                dst.data[indexDst++] = work.data[i++] & 0xFF;
            }
            indexSrc += srcStride;
        }
    }
}

