/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sparse.GradientValue_I32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseTwo1_U8
implements SparseImageGradient<GrayU8, GradientValue_I32> {
    GrayU8 input;
    ImageBorder_S32<GrayU8> border;
    GradientValue_I32 gradient = new GradientValue_I32();

    public GradientSparseTwo1_U8(ImageBorder_S32<GrayU8> border) {
        this.border = border;
    }

    public GradientValue_I32 compute(int x, int y) {
        int a10;
        int a01;
        int a11;
        if (x > 0 && y > 0 && x < this.input.width && y < this.input.height) {
            int s = this.input.stride;
            int br = this.input.startIndex + s * y + x;
            a11 = this.input.data[br] & 0xFF;
            a01 = this.input.data[br - s] & 0xFF;
            a10 = this.input.data[br - 1] & 0xFF;
        } else {
            a11 = this.border.get(x, y);
            a01 = this.border.get(x, y - 1);
            a10 = this.border.get(x - 1, y);
        }
        this.gradient.y = a11 - a01;
        this.gradient.x = a11 - a10;
        return this.gradient;
    }

    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }

    public void setImage(GrayU8 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage((ImageBase)input);
        }
    }

    public boolean isInBounds(int x, int y) {
        return this.border != null || x > 0 && y > 0 && x < this.input.width && y < this.input.height;
    }
}

