/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplColorYuv_MT {
    public static void yuvToRgb_F32(Planar<GrayF32> yuv, Planar<GrayF32> rgb) {
        GrayF32 Y = (GrayF32)yuv.getBand(0);
        GrayF32 U = (GrayF32)yuv.getBand(1);
        GrayF32 V = (GrayF32)yuv.getBand(2);
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)yuv.height, row -> {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                float y = Y.data[indexYuv];
                float u = U.data[indexYuv];
                float v = V.data[indexYuv];
                R.data[indexRgb] = y + 1.13983f * v;
                G.data[indexRgb] = y - 0.39465f * u - 0.5806f * v;
                B.data[indexRgb] = y + 2.032f * u;
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        });
    }

    public static void rgbToYuv_F32(Planar<GrayF32> rgb, Planar<GrayF32> yuv) {
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        GrayF32 Y = (GrayF32)yuv.getBand(0);
        GrayF32 U = (GrayF32)yuv.getBand(1);
        GrayF32 V = (GrayF32)yuv.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)yuv.height, row -> {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                float y;
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                Y.data[indexYuv] = y = 0.299f * r + 0.587f * g + 0.114f * b;
                U.data[indexYuv] = 0.492f * (b - y);
                V.data[indexYuv] = 0.877f * (r - y);
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        });
    }

    public static void ycbcrToRgb_U8(Planar<GrayU8> yuv, Planar<GrayU8> rgb) {
        GrayU8 Y = (GrayU8)yuv.getBand(0);
        GrayU8 U = (GrayU8)yuv.getBand(1);
        GrayU8 V = (GrayU8)yuv.getBand(2);
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)yuv.height, row -> {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                int y = 1191 * ((Y.data[indexYuv] & 0xFF) - 16);
                int cb = (U.data[indexYuv] & 0xFF) - 128;
                int cr = (V.data[indexYuv] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexRgb] = (byte)r;
                G.data[indexRgb] = (byte)g;
                B.data[indexRgb] = (byte)b;
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        });
    }
}

