/*
 * Copyright (c) 2011-2019, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.core.image.impl;

import boofcv.struct.image.*;

import javax.annotation.Generated;
//CONCURRENT_INLINE import boofcv.concurrency.BoofConcurrency;

/**
 * Low level implementations of different methods for converting {@link Planar} into
 * {@link boofcv.struct.image.ImageGray}.
 * 
 * <ul>
 * <li>Average computes the average value of each pixel across the bands.
 * </ul>
 * 
 * <p>
 * DO NOT MODIFY. This code was automatically generated by GenerateImplConvertPlanarToGray.
 * <p>
 *
 * @author Peter Abeles
 */
@Generated("boofcv.core.image.impl.GenerateImplConvertPlanarToGray")
@SuppressWarnings("Duplicates")
public class ImplConvertPlanarToGray {

	public static void average( Planar<GrayU8> from , GrayU8 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayU8 band0 = from.getBand(0);
			GrayU8 band1 = from.getBand(1);
			GrayU8 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = band0.data[indexFrom]& 0xFF;
					sum += band1.data[indexFrom]& 0xFF;
					sum += band2.data[indexFrom]& 0xFF;

					to.data[indexTo++] = (byte)(sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom]& 0xFF;
					}
					to.data[indexTo++] = (byte)(sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayS8> from , GrayS8 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayS8 band0 = from.getBand(0);
			GrayS8 band1 = from.getBand(1);
			GrayS8 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (byte)(sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (byte)(sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayU16> from , GrayU16 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayU16 band0 = from.getBand(0);
			GrayU16 band1 = from.getBand(1);
			GrayU16 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = band0.data[indexFrom]& 0xFFFF;
					sum += band1.data[indexFrom]& 0xFFFF;
					sum += band2.data[indexFrom]& 0xFFFF;

					to.data[indexTo++] = (short)(sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom]& 0xFFFF;
					}
					to.data[indexTo++] = (short)(sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayS16> from , GrayS16 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayS16 band0 = from.getBand(0);
			GrayS16 band1 = from.getBand(1);
			GrayS16 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (short)(sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (short)(sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayS32> from , GrayS32 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayS32 band0 = from.getBand(0);
			GrayS32 band1 = from.getBand(1);
			GrayS32 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					int sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayS64> from , GrayS64 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayS64 band0 = from.getBand(0);
			GrayS64 band1 = from.getBand(1);
			GrayS64 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					long sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					long sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayF32> from , GrayF32 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayF32 band0 = from.getBand(0);
			GrayF32 band1 = from.getBand(1);
			GrayF32 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					float sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					float sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}

	public static void average( Planar<GrayF64> from , GrayF64 to ) {
		int numBands = from.getNumBands();

		if( numBands == 1 ) {
			to.setTo(from.getBand(0));
		} else if( numBands == 3 ) {
			GrayF64 band0 = from.getBand(0);
			GrayF64 band1 = from.getBand(1);
			GrayF64 band2 = from.getBand(2);

			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					double sum = band0.data[indexFrom];
					sum += band1.data[indexFrom];
					sum += band2.data[indexFrom];

					to.data[indexTo++] = (sum/3);
				}
			}
			//CONCURRENT_ABOVE });
		} else {
			//CONCURRENT_BELOW BoofConcurrency.loopFor(0, from.height, y -> {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ , indexFrom++ ) {
					double sum = 0;
					for( int b = 0; b < numBands; b++ ) {
						sum +=  from.bands[b].data[indexFrom];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
			//CONCURRENT_ABOVE });
		}
	}


}
