/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import org.ejml.FancyPrint;

public class CameraKannalaBrandt
extends CameraPinhole {
    public double[] symmetric;
    public double[] radial;
    public double[] radialTrig;
    public double[] tangent;
    public double[] tangentTrig;

    public CameraKannalaBrandt(int numSymmetric, int numAsymmetric) {
        this.configureCoefficients(numSymmetric, numAsymmetric);
    }

    public CameraKannalaBrandt(CameraKannalaBrandt src) {
        this.setTo(src);
    }

    public CameraKannalaBrandt() {
        this(0, 0);
    }

    public void configureCoefficients(int numSymmetric, int numAsymmetric) {
        int numTrig = numAsymmetric != 0 ? 4 : 0;
        this.symmetric = new double[numSymmetric];
        this.radial = new double[numAsymmetric];
        this.tangent = new double[numAsymmetric];
        this.radialTrig = new double[numTrig];
        this.tangentTrig = new double[numTrig];
    }

    @Override
    public CameraKannalaBrandt fsetK(double fx, double fy, double skew, double cx, double cy) {
        super.fsetK(fx, fy, skew, cx, cy);
        return this;
    }

    @Override
    public CameraKannalaBrandt fsetShape(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public CameraKannalaBrandt fsetSymmetric(double ... coefs) {
        this.symmetric = (double[])coefs.clone();
        return this;
    }

    public CameraKannalaBrandt fsetRadial(double ... coefs) {
        this.radial = (double[])coefs.clone();
        return this;
    }

    public CameraKannalaBrandt fsetTangent(double ... coefs) {
        this.tangent = (double[])coefs.clone();
        return this;
    }

    public CameraKannalaBrandt fsetRadialTrig(double ... coefs) {
        BoofMiscOps.checkTrue((coefs.length == 0 || coefs.length == 4 ? 1 : 0) != 0);
        this.radialTrig = (double[])coefs.clone();
        return this;
    }

    public CameraKannalaBrandt fsetTangentTrig(double ... coefs) {
        BoofMiscOps.checkTrue((coefs.length == 0 || coefs.length == 4 ? 1 : 0) != 0);
        this.tangentTrig = (double[])coefs.clone();
        return this;
    }

    public boolean isSymmetricModel() {
        boolean noRadial = true;
        for (int i = 0; i < this.radial.length; ++i) {
            if (this.radial[i] == 0.0) continue;
            noRadial = false;
            break;
        }
        boolean noTangential = true;
        for (int i = 0; i < this.tangent.length; ++i) {
            if (this.tangent[i] == 0.0) continue;
            noTangential = false;
            break;
        }
        return noRadial && noTangential;
    }

    public boolean isAsymmetricModel() {
        if (this.radial.length != 0 && this.radialTrig.length == 4) {
            return true;
        }
        return this.tangent.length != 0 && this.tangentTrig.length == 4;
    }

    public CameraKannalaBrandt setTo(CameraKannalaBrandt src) {
        super.setTo(src);
        this.symmetric = BoofMiscOps.copySmart((double[])src.symmetric, (double[])this.symmetric);
        this.radial = BoofMiscOps.copySmart((double[])src.radial, (double[])this.radial);
        this.radialTrig = BoofMiscOps.copySmart((double[])src.radialTrig, (double[])this.radialTrig);
        this.tangent = BoofMiscOps.copySmart((double[])src.tangent, (double[])this.tangent);
        this.tangentTrig = BoofMiscOps.copySmart((double[])src.tangentTrig, (double[])this.tangentTrig);
        return this;
    }

    public boolean isIdentical(CameraKannalaBrandt src) {
        if (!super.isEquals(src, 0.0)) {
            return false;
        }
        if (!CameraKannalaBrandt.isIdentical(this.symmetric, src.symmetric)) {
            return false;
        }
        if (!CameraKannalaBrandt.isIdentical(this.radial, src.radial)) {
            return false;
        }
        if (!CameraKannalaBrandt.isIdentical(this.radialTrig, src.radialTrig)) {
            return false;
        }
        if (!CameraKannalaBrandt.isIdentical(this.tangent, src.tangent)) {
            return false;
        }
        return CameraKannalaBrandt.isIdentical(this.tangentTrig, src.tangentTrig);
    }

    private static boolean isIdentical(double[] a, double[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends CameraModel> T createLike() {
        return (T)new CameraKannalaBrandt(this.symmetric.length, this.radial.length);
    }

    @Override
    public String toString() {
        FancyPrint fp = new FancyPrint();
        String txt = "CameraKannalaBrandt{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + ", width=" + this.width + ", height=" + this.height;
        txt = txt + CameraPinholeBrown.toStringArray(fp, "s", this.symmetric);
        txt = txt + CameraPinholeBrown.toStringArray(fp, "r", this.radial);
        txt = txt + CameraPinholeBrown.toStringArray(fp, "rt", this.radialTrig);
        txt = txt + CameraPinholeBrown.toStringArray(fp, "t", this.tangent);
        txt = txt + CameraPinholeBrown.toStringArray(fp, "tt", this.tangentTrig);
        txt = txt + "}";
        return txt;
    }

    @Override
    public void print() {
        super.print();
        CameraKannalaBrandt.printArray("symmetric", this.symmetric);
        CameraKannalaBrandt.printArray("radial", this.radial);
        CameraKannalaBrandt.printArray("tangential", this.tangent);
        CameraKannalaBrandt.printArray("radial_trig", this.radialTrig);
        CameraKannalaBrandt.printArray("tangent_trig", this.tangentTrig);
    }

    private static void printArray(String name, double[] coefs) {
        if (coefs.length > 0) {
            System.out.print(name + " = [ ");
            for (int i = 0; i < coefs.length; ++i) {
                System.out.printf("%6.2e ", coefs[i]);
            }
            System.out.println("]");
        } else {
            System.out.println("No " + name);
        }
    }

    public double[] getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(double[] symmetric) {
        this.symmetric = symmetric;
    }

    public double[] getRadial() {
        return this.radial;
    }

    public double[] getRadialTrig() {
        return this.radialTrig;
    }

    public void setRadial(double[] radial) {
        this.radial = radial;
    }

    public void setRadialTrig(double[] radialTrig) {
        this.radialTrig = radialTrig;
    }

    public double[] getTangent() {
        return this.tangent;
    }

    public double[] getTangentTrig() {
        return this.tangentTrig;
    }

    public void setTangent(double[] tangent) {
        this.tangent = tangent;
    }

    public void setTangentTrig(double[] tangentTrig) {
        this.tangentTrig = tangentTrig;
    }
}

