/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.struct.calib.CameraPinhole;
import georegression.struct.se.Se3_F64;

public class MetricCameraTriple {
    public final Se3_F64 view_1_to_2 = new Se3_F64();
    public final Se3_F64 view_1_to_3 = new Se3_F64();
    public final CameraPinhole view1 = new CameraPinhole();
    public final CameraPinhole view2 = new CameraPinhole();
    public final CameraPinhole view3 = new CameraPinhole();

    public void setTo(MetricCameraTriple src) {
        this.view_1_to_2.setTo(src.view_1_to_2);
        this.view_1_to_3.setTo(src.view_1_to_3);
        this.view1.setTo(src.view1);
        this.view2.setTo(src.view2);
        this.view3.setTo(src.view3);
    }

    public CameraPinhole getIntrinsics(int viewIdx) {
        CameraPinhole cameraPinhole;
        switch (viewIdx) {
            case 0: {
                cameraPinhole = this.view1;
                break;
            }
            case 1: {
                cameraPinhole = this.view2;
                break;
            }
            case 2: {
                cameraPinhole = this.view3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index " + viewIdx);
            }
        }
        return cameraPinhole;
    }

    public Se3_F64 getView1ToIdx(int viewIdx) {
        Se3_F64 se3_F64;
        switch (viewIdx) {
            case 0: {
                se3_F64 = new Se3_F64();
                break;
            }
            case 1: {
                se3_F64 = this.view_1_to_2;
                break;
            }
            case 2: {
                se3_F64 = this.view_1_to_3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index " + viewIdx);
            }
        }
        return se3_F64;
    }

    public void getView1ToIdx(int viewIdx, Se3_F64 output) {
        switch (viewIdx) {
            case 0: {
                output.reset();
                break;
            }
            case 1: {
                output.setTo(this.view_1_to_2);
                break;
            }
            case 2: {
                output.setTo(this.view_1_to_3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index " + viewIdx);
            }
        }
    }
}

