/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.rectify;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class RectifyCalibrated {
    final DMatrixRMaj undistToRectPixels1 = new DMatrixRMaj(3, 3);
    final DMatrixRMaj undistToRectPixels2 = new DMatrixRMaj(3, 3);
    final Vector3D_F64 v1 = new Vector3D_F64();
    final Vector3D_F64 v2 = new Vector3D_F64();
    final Vector3D_F64 v3 = new Vector3D_F64();
    final SimpleMatrix K = new SimpleMatrix(3, 3);
    DMatrixRMaj rectifiedRotation;

    public void process(DMatrixRMaj K1, Se3_F64 worldToCamera1, DMatrixRMaj K2, Se3_F64 worldToCamera2) {
        SimpleMatrix sK1 = SimpleMatrix.wrap((Matrix)K1);
        SimpleMatrix sK2 = SimpleMatrix.wrap((Matrix)K2);
        SimpleMatrix R1 = SimpleMatrix.wrap((Matrix)worldToCamera1.getR());
        SimpleMatrix R2 = SimpleMatrix.wrap((Matrix)worldToCamera2.getR());
        SimpleMatrix T1 = new SimpleMatrix(3, 1, true, new double[]{worldToCamera1.getT().x, worldToCamera1.getT().y, worldToCamera1.getT().z});
        SimpleMatrix T2 = new SimpleMatrix(3, 1, true, new double[]{worldToCamera2.getT().x, worldToCamera2.getT().y, worldToCamera2.getT().z});
        SimpleMatrix KR1 = (SimpleMatrix)sK1.mult((ConstMatrix)R1);
        SimpleMatrix KR2 = (SimpleMatrix)sK2.mult((ConstMatrix)R2);
        SimpleMatrix c1 = (SimpleMatrix)((SimpleMatrix)R1.transpose()).mult((ConstMatrix)T1.scale(-1.0));
        SimpleMatrix c2 = (SimpleMatrix)((SimpleMatrix)R2.transpose()).mult((ConstMatrix)T2.scale(-1.0));
        this.selectAxises(R1, R2, c1, c2);
        SimpleMatrix RR = new SimpleMatrix(3, 3, true, new double[]{this.v1.x, this.v1.y, this.v1.z, this.v2.x, this.v2.y, this.v2.z, this.v3.x, this.v3.y, this.v3.z});
        this.K.setTo((SimpleBase)((SimpleMatrix)((SimpleMatrix)sK1.plus((ConstMatrix)sK2)).scale(0.5)));
        this.K.set(0, 1, 0.0);
        SimpleMatrix KRR = (SimpleMatrix)this.K.mult((ConstMatrix)RR);
        this.undistToRectPixels1.setTo((DMatrixD1)((SimpleMatrix)KRR.mult((ConstMatrix)KR1.invert())).getDDRM());
        this.undistToRectPixels2.setTo((DMatrixD1)((SimpleMatrix)KRR.mult((ConstMatrix)KR2.invert())).getDDRM());
        this.rectifiedRotation = RR.getDDRM();
    }

    private void selectAxises(SimpleMatrix R1, SimpleMatrix R2, SimpleMatrix c1, SimpleMatrix c2) {
        this.v1.setTo(c2.get(0) - c1.get(0), c2.get(1) - c1.get(1), c2.get(2) - c1.get(2));
        this.v1.normalize();
        Vector3D_F64 oldZ = new Vector3D_F64(R1.get(2, 0) + R2.get(2, 0), R1.get(2, 1) + R2.get(2, 1), R1.get(2, 2) + R2.get(2, 2));
        GeometryMath_F64.cross((GeoTuple3D_F64)oldZ, (GeoTuple3D_F64)this.v1, (GeoTuple3D_F64)this.v2);
        this.v2.normalize();
        GeometryMath_F64.cross((GeoTuple3D_F64)this.v1, (GeoTuple3D_F64)this.v2, (GeoTuple3D_F64)this.v3);
        this.v3.normalize();
    }

    public DMatrixRMaj getCalibrationMatrix() {
        return this.K.getDDRM();
    }

    public DMatrixRMaj getUndistToRectPixels1() {
        return this.undistToRectPixels1;
    }

    public DMatrixRMaj getUndistToRectPixels2() {
        return this.undistToRectPixels2;
    }

    public DMatrixRMaj getRectifiedRotation() {
        return this.rectifiedRotation;
    }
}

