/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class PositiveDepthConstraintCheckH {
    Triangulate2ViewsMetricH triangulate;
    Point4D_F64 p = new Point4D_F64();

    public PositiveDepthConstraintCheckH(Triangulate2ViewsMetricH triangulate) {
        this.triangulate = triangulate;
    }

    public PositiveDepthConstraintCheckH() {
        this(FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC)));
    }

    public boolean checkConstraint(Point2D_F64 viewA, Point2D_F64 viewB, Se3_F64 fromAtoB) {
        if (!this.triangulate.triangulate(viewA, viewB, fromAtoB, this.p)) {
            throw new RuntimeException("Triangulate failed. p1=" + viewA + " p2=" + viewB);
        }
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return false;
        }
        SePointOps_F64.transform((Se3_F64)fromAtoB, (Point4D_F64)this.p, (Point4D_F64)this.p);
        return !PerspectiveOps.isBehindCamera(this.p);
    }
}

