/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

import boofcv.alg.distort.kanbra.KannalaBrandtUtils_F64;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.distort.Point3Transform2_F32;
import georegression.geometry.UtilPoint3D_F32;
import georegression.struct.point.Point2D_F32;

public class KannalaBrandtStoP_F32
implements Point3Transform2_F32 {
    protected final CameraKannalaBrandt model;

    public KannalaBrandtStoP_F32(CameraKannalaBrandt model) {
        BoofMiscOps.checkTrue((model.radialTrig.length == 0 || model.radialTrig.length == 4 ? 1 : 0) != 0);
        this.model = new CameraKannalaBrandt(model);
    }

    public void compute(float x, float y, float z, Point2D_F32 out) {
        float dy;
        float dx;
        float theta = (float)Math.acos(z / UtilPoint3D_F32.norm((float)x, (float)y, (float)z));
        float r = (float)KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        float phi = (float)Math.atan2(y, x);
        float cosphi = (float)Math.cos(phi);
        float sinphi = (float)Math.sin(phi);
        if (this.model.isAsymmetricModel()) {
            float disRad = (float)(KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi));
            float disTan = (float)(KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi));
            dx = (r + disRad) * cosphi - disTan * sinphi;
            dy = (r + disRad) * sinphi + disTan * cosphi;
        } else {
            dx = r * cosphi;
            dy = r * sinphi;
        }
        out.x = (float)(this.model.fx * (double)dx + this.model.skew * (double)dy + this.model.cx);
        out.y = (float)(this.model.fy * (double)dy + this.model.cy);
    }

    public Point3Transform2_F32 copyConcurrent() {
        return this;
    }

    public CameraKannalaBrandt getModel() {
        return this.model;
    }
}

