/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationQuality;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationObservationSet;
import boofcv.alg.geo.calibration.ScoreCalibrationFill;
import boofcv.alg.geo.calibration.SynchronizedCalObs;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.MultiCameraCalibParams;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.stats.StatisticsDogArray;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class CalibrateMultiPlanar {
    final CalibrateMonoPlanar calibratorMono = new CalibrateMonoPlanar();
    MetricBundleAdjustmentUtils bundleUtils = new MetricBundleAdjustmentUtils(null, false);
    MultiCameraCalibParams results = new MultiCameraCalibParams();
    DogArray<CameraStatistics> statistics = new DogArray(CameraStatistics::new, CameraStatistics::reset);
    final FastArray<List<Point2D_F64>> layouts = new FastArray(ArrayList.class);
    final DogArray<CameraPriors> cameras = new DogArray(CameraPriors::new);
    final List<SynchronizedCalObs> frameObs = new ArrayList<SynchronizedCalObs>();

    public void initialize(int numCameras, int numTargets) {
        if (numTargets != 1) {
            throw new RuntimeException("Currently only supports one target");
        }
        this.statistics.reset().resize(numCameras);
        this.results.reset();
        this.layouts.resize(numTargets);
        this.cameras.reset().resize(numCameras);
        for (int i = 0; i < this.cameras.size; ++i) {
            ((CameraPriors)this.cameras.get((int)i)).index = i;
            this.results.camerasToSensor.add(new Se3_F64());
        }
        this.frameObs.clear();
    }

    public void setCameraProperties(int which, int width, int height) {
        ((CameraPriors)this.cameras.get((int)which)).width = width;
        ((CameraPriors)this.cameras.get((int)which)).height = height;
    }

    public void setTargetLayout(int which, List<Point2D_F64> layout) {
        this.layouts.set(which, layout);
    }

    public void addObservation(SynchronizedCalObs observations) {
        this.frameObs.add(observations);
    }

    public boolean process() {
        int targetID = 0;
        ArrayList<FrameState> frames = new ArrayList<FrameState>();
        for (int i = 0; i < this.frameObs.size(); ++i) {
            frames.add(new FrameState());
        }
        this.monocularCalibration(targetID, frames);
        this.estimateCameraToSensor(frames);
        this.estimateSensorToWorldInAllFrames(frames);
        this.setupSbaScene(targetID, frames);
        if (!this.bundleUtils.process()) {
            return false;
        }
        this.sbaToOutput();
        this.computeReprojectionErrors();
        return true;
    }

    void monocularCalibration(int targetID, List<FrameState> frames) {
        ScoreCalibrationFill fillScore = new ScoreCalibrationFill();
        DogArray_I32 usedFrames = new DogArray_I32();
        for (int cameraIdx = 0; cameraIdx < this.cameras.size; ++cameraIdx) {
            usedFrames.reset();
            CameraPriors c = (CameraPriors)this.cameras.get(cameraIdx);
            this.calibratorMono.initialize(c.width, c.height, (List)this.layouts.get(targetID));
            block1: for (int frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
                SynchronizedCalObs synch = this.frameObs.get(frameIdx);
                for (int frameCamIdx = 0; frameCamIdx < synch.cameras.size; ++frameCamIdx) {
                    CalibrationObservationSet os = (CalibrationObservationSet)synch.cameras.get(frameCamIdx);
                    if (os.cameraID != c.index) continue;
                    CalibrationObservation monoObs = new CalibrationObservation();
                    monoObs.points.addAll(((CalibrationObservation)os.targets.get((int)0)).points);
                    this.calibratorMono.addImage(monoObs);
                    usedFrames.add(frameIdx);
                    continue block1;
                }
            }
            this.results.getIntrinsics().add((CameraModel)this.calibratorMono.process());
            CalibrateMonoPlanar.computeQuality(this.calibratorMono.foundIntrinsic, fillScore, (List)this.layouts.get(0), this.calibratorMono.observations, ((CameraStatistics)this.statistics.get((int)cameraIdx)).quality);
            for (int usedIdx = 0; usedIdx < usedFrames.size(); ++usedIdx) {
                int frameID = usedFrames.get(usedIdx);
                CalibrationObservationSet obs = this.frameObs.get(frameID).findCamera(c.index);
                Objects.requireNonNull(obs, "BUG!");
                FrameState frame = frames.get(frameID);
                FrameCamera cam = (FrameCamera)frame.cameras.get(cameraIdx);
                if (cam == null) {
                    cam = new FrameCamera();
                    frame.cameras.put(cameraIdx, (Object)cam);
                }
                TargetExtrinsics target = new TargetExtrinsics();
                target.targetID = targetID;
                target.targetToCamera.setTo(this.calibratorMono.getTargetToView(usedIdx));
                cam.observations.add(target);
            }
        }
    }

    void estimateCameraToSensor(List<FrameState> frames) {
        ArrayList<CameraPriors> known = new ArrayList<CameraPriors>();
        ArrayList<CameraPriors> unknown = new ArrayList<CameraPriors>();
        for (int i = 1; i < this.cameras.size; ++i) {
            unknown.add((CameraPriors)this.cameras.get(i));
        }
        known.add((CameraPriors)this.cameras.get(0));
        while (unknown.size() > 0) {
            boolean change = false;
            block2: for (int unknownIdx = unknown.size() - 1; unknownIdx >= 0; --unknownIdx) {
                CameraPriors unknownCam = (CameraPriors)unknown.get(unknownIdx);
                for (int frameIdx = 0; frameIdx < frames.size(); ++frameIdx) {
                    FrameState frame = frames.get(frameIdx);
                    for (int knownIdx = 0; knownIdx < known.size(); ++knownIdx) {
                        CameraPriors knownCam = (CameraPriors)known.get(knownIdx);
                        Se3_F64 camI_to_sensor = this.extrinsicFromKnownCamera(frame, knownCam.index, unknownCam.index);
                        if (camI_to_sensor == null) continue;
                        this.results.camerasToSensor.get(unknownCam.index).setTo(camI_to_sensor);
                        change = true;
                        unknown.remove(unknownIdx);
                        known.add(unknownCam);
                        continue block2;
                    }
                }
            }
            if (change) continue;
            break;
        }
        if (!unknown.isEmpty()) {
            throw new RuntimeException("Not all cameras have known extrinsics");
        }
    }

    void estimateSensorToWorldInAllFrames(List<FrameState> frames) {
        for (int frameIdx = 0; frameIdx < frames.size(); ++frameIdx) {
            FrameState f = frames.get(frameIdx);
            boolean found = false;
            for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
                int obsIdx;
                FrameCamera fc = (FrameCamera)f.cameras.get(camIdx);
                if (fc == null || (obsIdx = 0) >= fc.observations.size()) continue;
                TargetExtrinsics te = fc.observations.get(obsIdx);
                Se3_F64 cameraToTarget = te.targetToCamera.invert(null);
                this.results.getCameraToSensor(camIdx).invertConcat(cameraToTarget, f.sensorToWorld);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("This frame should be removed");
        }
    }

    void setupSbaScene(int targetID, List<FrameState> frames) {
        int camIdx;
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        SceneObservations observations = this.bundleUtils.getObservations();
        List layout = (List)this.layouts.get(targetID);
        int totalViews = frames.size() * this.cameras.size;
        int totalMotions = this.cameras.size;
        structure.initialize(this.cameras.size, totalViews, totalMotions, 0, 1);
        for (int i = 0; i < this.cameras.size; ++i) {
            structure.setCamera(i, false, (CameraPinholeBrown)this.results.getIntrinsics().get(i));
        }
        for (int camIdx2 = 0; camIdx2 < this.cameras.size; ++camIdx2) {
            structure.addMotion(camIdx2 == 0, this.results.getCameraToSensor(camIdx2).invert(null));
        }
        int viewIdx = 0;
        for (int frameIdx = 0; frameIdx < frames.size(); ++frameIdx) {
            int cameraZeroIdx = viewIdx;
            Se3_F64 worldToSensor = frames.get((int)frameIdx).sensorToWorld.invert(null);
            structure.setView(viewIdx++, 0, false, worldToSensor);
            for (camIdx = 1; camIdx < this.cameras.size; ++camIdx) {
                structure.setView(viewIdx++, camIdx, camIdx, cameraZeroIdx);
            }
        }
        structure.setRigid(0, true, new Se3_F64(), layout.size());
        SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[0];
        for (int i = 0; i < layout.size(); ++i) {
            rigid.setPoint(i, ((Point2D_F64)layout.get((int)i)).x, ((Point2D_F64)layout.get((int)i)).y, 0.0);
        }
        observations.initialize(totalViews, true);
        for (int frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
            SynchronizedCalObs f = this.frameObs.get(frameIdx);
            for (camIdx = 0; camIdx < f.cameras.size; ++camIdx) {
                CalibrationObservationSet c = (CalibrationObservationSet)f.cameras.get(camIdx);
                int sbaViewIndex = frameIdx * this.cameras.size + c.cameraID;
                SceneObservations.View sbaView = observations.getViewRigid(sbaViewIndex);
                for (int obsIdx = 0; obsIdx < c.targets.size; ++obsIdx) {
                    CalibrationObservation o = (CalibrationObservation)c.targets.get(obsIdx);
                    for (int featIdx = 0; featIdx < o.size(); ++featIdx) {
                        PointIndex2D_F64 p = o.get(featIdx);
                        sbaView.add(p.index, (float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y);
                        rigid.connectPointToView(sbaViewIndex, p.index);
                    }
                }
            }
        }
    }

    void sbaToOutput() {
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
            CameraPriors c = (CameraPriors)this.cameras.get(camIdx);
            BundlePinholeBrown bb = (BundlePinholeBrown)structure.getCameraModel(camIdx);
            BundleAdjustmentOps.convert(bb, c.width, c.height, (CameraPinholeBrown)this.results.intrinsics.get(camIdx));
            ((SceneStructureMetric.Motion)structure.motions.get((int)camIdx)).parent_to_view.invert(this.results.camerasToSensor.get(camIdx));
        }
    }

    void computeReprojectionErrors() {
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        List layout = (List)this.layouts.get(0);
        WorldToCameraToPixel w2p = new WorldToCameraToPixel();
        Point3D_F64 worldPt = new Point3D_F64();
        Point2D_F64 predictedPixel = new Point2D_F64();
        DogArray_F64 errors = new DogArray_F64();
        for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
            CameraPinholeBrown intrinsics = (CameraPinholeBrown)this.results.intrinsics.get(camIdx);
            Se3_F64 cameraToSensor = this.results.getCameraToSensor(camIdx);
            double overallMean = 0.0;
            double overallMax = 0.0;
            int totalFrames = 0;
            for (int frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
                CalibrationObservation camObs;
                ImageResults imageStats = new ImageResults(errors.size);
                ((CameraStatistics)this.statistics.get((int)camIdx)).residuals.add(imageStats);
                CalibrationObservationSet camSet = this.frameObs.get(frameIdx).findCamera(camIdx);
                if (camSet == null || (camObs = camSet.findTarget(0)) == null) continue;
                ++totalFrames;
                Se3_F64 worldToSensor = ((SceneStructureMetric.Motion)structure.motions.get((int)(this.cameras.size + frameIdx))).parent_to_view;
                Se3_F64 worldToCamera = worldToSensor.concat(cameraToSensor.invert(null), null);
                w2p.configure(intrinsics, worldToCamera);
                errors.reset();
                double sumX = 0.0;
                double sumY = 0.0;
                for (int obsIdx = 0; obsIdx < camObs.points.size(); ++obsIdx) {
                    PointIndex2D_F64 o = camObs.points.get(obsIdx);
                    Point2D_F64 landmarkX = (Point2D_F64)layout.get(o.index);
                    worldPt.x = landmarkX.x;
                    worldPt.y = landmarkX.y;
                    w2p.transform(worldPt, predictedPixel);
                    double dx = predictedPixel.x - ((Point2D_F64)o.p).x;
                    double dy = predictedPixel.y - ((Point2D_F64)o.p).y;
                    errors.add(Math.sqrt(dx * dx + dy * dy));
                    sumX += dx;
                    sumY += dy;
                }
                errors.sort();
                imageStats.maxError = errors.getFraction(1.0);
                imageStats.meanError = StatisticsDogArray.mean((DogArray_F64)errors);
                imageStats.biasX += sumX / (double)camObs.points.size();
                imageStats.biasY += sumY / (double)camObs.points.size();
                overallMean += imageStats.meanError;
                overallMax = Math.max(overallMax, imageStats.maxError);
            }
            CameraStatistics stats = (CameraStatistics)this.statistics.get(camIdx);
            stats.overallMax = overallMax;
            stats.overallMean = overallMean / (double)totalFrames;
        }
    }

    @Nullable
    Se3_F64 extrinsicFromKnownCamera(FrameState frame, int camId0, int camId1) {
        FrameCamera state0 = (FrameCamera)frame.cameras.get(camId0);
        FrameCamera state1 = (FrameCamera)frame.cameras.get(camId1);
        if (state0 == null || state1 == null) {
            return null;
        }
        for (int obsIdx0 = 0; obsIdx0 < state0.observations.size(); ++obsIdx0) {
            TargetExtrinsics tgt0 = state0.observations.get(obsIdx0);
            TargetExtrinsics tgt1 = state1.findTarget(tgt0.targetID);
            if (tgt1 == null) continue;
            Se3_F64 cam0_to_cam1 = new Se3_F64();
            tgt0.targetToCamera.invertConcat(tgt1.targetToCamera, cam0_to_cam1);
            Se3_F64 cam0_to_sensor = this.results.getCameraToSensor(camId0);
            return cam0_to_cam1.invertConcat(cam0_to_sensor, null);
        }
        return null;
    }

    public String computeQualityText() {
        CameraStatistics cam;
        int camId;
        StringBuilder builder = new StringBuilder();
        builder.append("Calibration Quality Metrics:\n");
        for (camId = 0; camId < this.statistics.size; ++camId) {
            cam = (CameraStatistics)this.statistics.get(camId);
            builder.append(String.format("  camera[%d] fill_border=%5.3f fill_inner=%5.3f geometric=%5.3f\n", camId, cam.quality.borderFill, cam.quality.innerFill, cam.quality.geometric));
        }
        builder.append('\n');
        builder.append("Summary Residual Metrics:\n");
        for (camId = 0; camId < this.statistics.size; ++camId) {
            cam = (CameraStatistics)this.statistics.get(camId);
            builder.append(String.format("  camera[%3d] mean=%6.2f max=%6.2f\n", camId, cam.overallMean, cam.overallMax));
        }
        builder.append('\n');
        for (camId = 0; camId < this.statistics.size; ++camId) {
            builder.append("Residual Errors: Camera ").append(camId).append("\n");
            cam = (CameraStatistics)this.statistics.get(camId);
            for (int frameIdx = 0; frameIdx < cam.residuals.size(); ++frameIdx) {
                ImageResults img = cam.residuals.get(frameIdx);
                builder.append(String.format("  img[%4d] mean=%6.2f max=%6.2f\n", frameIdx, img.meanError, img.maxError));
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    public CalibrateMonoPlanar getCalibratorMono() {
        return this.calibratorMono;
    }

    public MetricBundleAdjustmentUtils getBundleUtils() {
        return this.bundleUtils;
    }

    public MultiCameraCalibParams getResults() {
        return this.results;
    }

    public DogArray<CameraStatistics> getStatistics() {
        return this.statistics;
    }

    public static class CameraPriors {
        int index;
        int width;
        int height;
    }

    public static class FrameState {
        TIntObjectMap<FrameCamera> cameras = new TIntObjectHashMap();
        Se3_F64 sensorToWorld = new Se3_F64();
    }

    public static class CameraStatistics {
        public CalibrationQuality quality = new CalibrationQuality();
        public List<ImageResults> residuals = new ArrayList<ImageResults>();
        public double overallMean = 0.0;
        public double overallMax = 0.0;

        public void reset() {
            this.quality.reset();
            this.residuals.clear();
            this.overallMax = 0.0;
            this.overallMean = 0.0;
        }
    }

    public static class FrameCamera {
        public List<TargetExtrinsics> observations = new ArrayList<TargetExtrinsics>();

        @Nullable
        public TargetExtrinsics findTarget(int targetID) {
            for (int i = 0; i < this.observations.size(); ++i) {
                if (this.observations.get((int)i).targetID != targetID) continue;
                return this.observations.get(i);
            }
            return null;
        }
    }

    public static class TargetExtrinsics {
        public int targetID;
        public Se3_F64 targetToCamera = new Se3_F64();

        public TargetExtrinsics(int targetID) {
            this.targetID = targetID;
        }

        public TargetExtrinsics() {
        }
    }
}

