/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.filter.binary.BinaryContourFinderLinearExternal;
import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.alg.shapes.ellipse.SnapToEllipseEdge;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.alg.shapes.polygon.RefinePolygonToContour;
import boofcv.alg.shapes.polygon.RefinePolygonToGray;
import boofcv.alg.shapes.polygon.RefinePolygonToGrayLine;
import boofcv.factory.filter.binary.FactoryBinaryContourFinder;
import boofcv.factory.shape.ConfigEllipseDetector;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.ConfigPolygonFromContour;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.factory.shape.FactoryPointsToPolyline;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class FactoryShapeDetector {
    public static <T extends ImageGray<T>> BinaryEllipseDetector<T> ellipse(@Nullable ConfigEllipseDetector config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigEllipseDetector();
        }
        config.checkValidity();
        BinaryEllipseDetectorPixel detector = new BinaryEllipseDetectorPixel(config.contourRule);
        detector.setMaxDistanceFromEllipse(config.maxDistanceFromEllipse);
        detector.setMaximumContour(config.maximumContour);
        detector.setMinimumContour(config.minimumContour);
        detector.setMinimumMinorAxis(config.minimumMinorAxis);
        detector.setInternalContour(config.processInternal);
        detector.setMaxMajorToMinorRatio(config.maxMajorToMinorRatio);
        SnapToEllipseEdge<T> refine = new SnapToEllipseEdge<T>(config.numSampleContour, config.refineRadialSamples, imageType);
        refine.setConvergenceTol(config.convergenceTol);
        refine.setMaxIterations(config.maxIterations);
        if (config.maxIterations <= 0 || config.numSampleContour <= 0) {
            refine = null;
        }
        EdgeIntensityEllipse<T> check = new EdgeIntensityEllipse<T>(config.checkRadialDistance, config.numSampleContour, config.minimumEdgeIntensity, imageType);
        return new BinaryEllipseDetector<T>(detector, refine, check, imageType);
    }

    public static <T extends ImageGray<T>> DetectPolygonBinaryGrayRefine<T> polygon(@Nullable ConfigPolygonDetector config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigPolygonDetector();
        }
        config.checkValidity();
        RefinePolygonToContour refineContour = config.refineContour ? new RefinePolygonToContour() : null;
        RefinePolygonToGray<T> refineGray = config.refineGray != null ? FactoryShapeDetector.refinePolygon(config.refineGray, imageType) : null;
        DetectPolygonFromContour<T> detector = FactoryShapeDetector.polygonContour(config.detector, imageType);
        return new DetectPolygonBinaryGrayRefine<T>(detector, refineContour, refineGray, config.minimumRefineEdgeIntensity, config.adjustForThresholdBias);
    }

    public static <T extends ImageGray<T>> DetectPolygonFromContour<T> polygonContour(ConfigPolygonFromContour config, Class<T> imageType) {
        config.checkValidity();
        PointsToPolyline contourToPolygon = FactoryPointsToPolyline.create(config.contourToPoly);
        BinaryContourFinderLinearExternal contour = FactoryBinaryContourFinder.linearExternal();
        contour.setConnectRule(config.contourRule);
        contour.setMinContour(config.minimumContour);
        contour.setMaxContour(config.maximumContour);
        return new DetectPolygonFromContour<T>(contourToPolygon, config.clockwise, config.canTouchBorder, config.minimumEdgeIntensity, config.tangentEdgeIntensity, (BinaryContourFinder)contour, imageType);
    }

    public static <T extends ImageGray<T>> RefinePolygonToGray<T> refinePolygon(ConfigRefinePolygonLineToImage config, Class<T> imageType) {
        return new RefinePolygonToGrayLine<T>(config.cornerOffset, config.lineSamples, config.sampleRadius, config.maxIterations, config.convergeTolPixels, config.maxCornerChangePixel, imageType);
    }
}

