/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.abst.shapes.polyline.BaseConfigPolyline;
import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;

public class ConfigPolygonFromContour
implements Configuration {
    public boolean canTouchBorder = false;
    public ConnectRule contourRule = ConnectRule.FOUR;
    public BaseConfigPolyline contourToPoly = new ConfigPolylineSplitMerge();
    public double minimumEdgeIntensity = 6.0;
    public double tangentEdgeIntensity = 2.5;
    public ConfigLength minimumContour = ConfigLength.relative((double)0.044, (double)4.0);
    public ConfigLength maximumContour = ConfigLength.fixed((double)-1.0);
    public boolean clockwise = true;

    public ConfigPolygonFromContour(int minimumSides, int maximumSides) {
        this.contourToPoly.minimumSides = minimumSides;
        this.contourToPoly.maximumSides = maximumSides;
    }

    public ConfigPolygonFromContour(boolean clockwise, int minimumSides, int maximumSides) {
        this.contourToPoly.minimumSides = minimumSides;
        this.contourToPoly.maximumSides = maximumSides;
        this.clockwise = clockwise;
    }

    public ConfigPolygonFromContour() {
    }

    public ConfigPolygonFromContour setTo(ConfigPolygonFromContour src) {
        this.canTouchBorder = src.canTouchBorder;
        this.contourRule = src.contourRule;
        this.contourToPoly.setTo(src.contourToPoly);
        this.minimumEdgeIntensity = src.minimumEdgeIntensity;
        this.tangentEdgeIntensity = src.tangentEdgeIntensity;
        this.minimumContour.setTo(src.minimumContour);
        this.maximumContour.setTo(src.maximumContour);
        this.clockwise = src.clockwise;
        return this;
    }

    public void checkValidity() {
        this.minimumContour.checkValidity();
        this.maximumContour.checkValidity();
    }

    public String toString() {
        return "ConfigPolygonFromContour{ contourToPoly=" + this.contourToPoly + ", minimumEdgeIntensity=" + this.minimumEdgeIntensity + ", tangentEdgeIntensity=" + this.tangentEdgeIntensity + ", minimumContour=" + this.minimumContour + ", maximumContour=" + this.maximumContour + ", clockwise=" + this.clockwise + "}";
    }
}

