/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;

public class ConfigEllipseDetector
implements Configuration {
    public double maxDistanceFromEllipse = 3.0;
    public ConfigLength minimumContour = ConfigLength.fixed((double)10.0);
    public ConfigLength maximumContour = ConfigLength.fixed((double)-1.0);
    public ConnectRule contourRule = ConnectRule.FOUR;
    public final ConfigLength minimumMinorAxis = ConfigLength.fixed((double)1.5);
    public boolean processInternal = false;
    public int maxIterations = 5;
    public double convergenceTol = 0.01;
    public int numSampleContour = 20;
    public int refineRadialSamples = 1;
    public double minimumEdgeIntensity = 20.0;
    public double checkRadialDistance = 1.5;
    public double maxMajorToMinorRatio = 20.0;

    public ConfigEllipseDetector setTo(ConfigEllipseDetector src) {
        this.maxDistanceFromEllipse = src.maxDistanceFromEllipse;
        this.minimumContour.setTo(src.minimumContour);
        this.maximumContour.setTo(src.maximumContour);
        this.contourRule = src.contourRule;
        this.minimumMinorAxis.setTo(src.minimumMinorAxis);
        this.processInternal = src.processInternal;
        this.maxIterations = src.maxIterations;
        this.convergenceTol = src.convergenceTol;
        this.numSampleContour = src.numSampleContour;
        this.refineRadialSamples = src.refineRadialSamples;
        this.minimumEdgeIntensity = src.minimumEdgeIntensity;
        this.checkRadialDistance = src.checkRadialDistance;
        this.maxMajorToMinorRatio = src.maxMajorToMinorRatio;
        return this;
    }

    public void checkValidity() {
        this.minimumContour.checkValidity();
        this.maximumContour.checkValidity();
    }
}

