/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.FastCornerDetector_MT;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.impl.HarrisCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.HarrisCorner_S32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner10_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner10_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner11_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner11_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner12_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner12_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner9_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner9_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerWeighted_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerWeighted_F32_MT;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerWeighted_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerWeighted_S16_MT;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCorner_F32_MT;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCorner_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCorner_S16_MT;
import boofcv.alg.feature.detect.intensity.impl.ShiTomasiCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ShiTomasiCorner_S32;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryIntensityPointAlg {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageGray<T>> FastCornerDetector<T> fast(int pixelTol, int minCont, Class<T> imageType) {
        void var3_11;
        if (imageType == GrayF32.class) {
            if (minCont == 9) {
                ImplFastCorner9_F32 implFastCorner9_F32 = new ImplFastCorner9_F32(pixelTol);
            } else if (minCont == 10) {
                ImplFastCorner10_F32 implFastCorner10_F32 = new ImplFastCorner10_F32(pixelTol);
            } else if (minCont == 11) {
                ImplFastCorner11_F32 implFastCorner11_F32 = new ImplFastCorner11_F32(pixelTol);
            } else {
                if (minCont != 12) throw new IllegalArgumentException("Specified minCont is not supported");
                ImplFastCorner12_F32 implFastCorner12_F32 = new ImplFastCorner12_F32(pixelTol);
            }
        } else {
            if (imageType != GrayU8.class) throw new IllegalArgumentException("Unknown image type");
            if (minCont == 9) {
                ImplFastCorner9_U8 implFastCorner9_U8 = new ImplFastCorner9_U8(pixelTol);
            } else if (minCont == 10) {
                ImplFastCorner10_U8 implFastCorner10_U8 = new ImplFastCorner10_U8(pixelTol);
            } else if (minCont == 11) {
                ImplFastCorner11_U8 implFastCorner11_U8 = new ImplFastCorner11_U8(pixelTol);
            } else {
                if (minCont != 12) throw new IllegalArgumentException("Specified minCont is not supported");
                ImplFastCorner12_U8 implFastCorner12_U8 = new ImplFastCorner12_U8(pixelTol);
            }
        }
        if (!BoofConcurrency.isUseConcurrent()) return new FastCornerDetector(var3_11);
        return new FastCornerDetector_MT(var3_11);
    }

    public static <D extends ImageGray<D>> GradientCornerIntensity<D> harris(int windowRadius, float kappa, boolean weighted, Class<D> derivType) {
        if (BoofConcurrency.USE_CONCURRENT) {
            if (derivType == GrayF32.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_F32_MT(windowRadius, new HarrisCorner_F32(kappa));
                }
                return new ImplSsdCorner_F32_MT(windowRadius, new HarrisCorner_F32(kappa));
            }
            if (derivType == GrayS16.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_S16_MT(windowRadius, new HarrisCorner_S32(kappa));
                }
                return new ImplSsdCorner_S16_MT(windowRadius, new HarrisCorner_S32(kappa));
            }
        } else {
            if (derivType == GrayF32.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_F32(windowRadius, new HarrisCorner_F32(kappa));
                }
                return new ImplSsdCorner_F32(windowRadius, new HarrisCorner_F32(kappa));
            }
            if (derivType == GrayS16.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_S16(windowRadius, new HarrisCorner_S32(kappa));
                }
                return new ImplSsdCorner_S16(windowRadius, new HarrisCorner_S32(kappa));
            }
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }

    public static <D extends ImageGray<D>> GradientCornerIntensity<D> shiTomasi(int windowRadius, boolean weighted, Class<D> derivType) {
        if (BoofConcurrency.USE_CONCURRENT) {
            if (derivType == GrayF32.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_F32_MT(windowRadius, new ShiTomasiCorner_F32());
                }
                return new ImplSsdCorner_F32_MT(windowRadius, new ShiTomasiCorner_F32());
            }
            if (derivType == GrayS16.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_S16_MT(windowRadius, new ShiTomasiCorner_S32());
                }
                return new ImplSsdCorner_S16_MT(windowRadius, new ShiTomasiCorner_S32());
            }
        } else {
            if (derivType == GrayF32.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_F32(windowRadius, new ShiTomasiCorner_F32());
                }
                return new ImplSsdCorner_F32(windowRadius, new ShiTomasiCorner_F32());
            }
            if (derivType == GrayS16.class) {
                if (weighted) {
                    return new ImplSsdCornerWeighted_S16(windowRadius, new ShiTomasiCorner_S32());
                }
                return new ImplSsdCorner_S16(windowRadius, new ShiTomasiCorner_S32());
            }
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }
}

