/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.shapes.polyline;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.shapes.polyline.RefinePolyLineCorner;
import boofcv.alg.shapes.polyline.splitmerge.PolylineSplitMerge;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;

public class NewSplitMerge_to_PointsToPolyline
implements PointsToPolyline {
    PolylineSplitMerge alg = new PolylineSplitMerge();
    RefinePolyLineCorner refine;

    public NewSplitMerge_to_PointsToPolyline(ConfigPolylineSplitMerge config) {
        this.alg.setMinimumSideLength(config.minimumSideLength);
        this.alg.setMaxNumberOfSideSamples(config.maxNumberOfSideSamples);
        this.alg.setMaxSides(config.maximumSides);
        this.alg.setMinSides(config.minimumSides);
        this.alg.setExtraConsider(config.extraConsider);
        this.alg.setConvex(config.convex);
        this.alg.setThresholdSideSplitScore(config.thresholdSideSplitScore);
        this.alg.setCornerScorePenalty(config.cornerScorePenalty);
        this.alg.setConvexTest(config.convexTest);
        this.alg.setMaxSideError(config.maxSideError);
        this.alg.setLoops(config.loops);
        if (config.refineIterations > 0) {
            this.refine = new RefinePolyLineCorner(config.loops, config.refineIterations);
        }
    }

    @Override
    public boolean process(List<Point2D_I32> input, DogArray_I32 vertexes) {
        if (!this.alg.process(input)) {
            return false;
        }
        PolylineSplitMerge.CandidatePolyline best = this.alg.getBestPolyline();
        if (best == null) {
            return false;
        }
        vertexes.setTo(best.splits);
        return this.refine == null || this.refine.fit(input, vertexes);
    }

    @Override
    public void setMinimumSides(int minimum) {
        this.alg.setMinSides(minimum);
    }

    @Override
    public int getMinimumSides() {
        return this.alg.getMinSides();
    }

    @Override
    public void setMaximumSides(int maximum) {
        this.alg.setMaxSides(maximum);
    }

    @Override
    public int getMaximumSides() {
        return this.alg.getMaxSides();
    }

    @Override
    public boolean isLoop() {
        return this.alg.isLoops();
    }

    @Override
    public void setConvex(boolean convex) {
        this.alg.setConvex(convex);
    }

    @Override
    public boolean isConvex() {
        return this.alg.isConvex();
    }
}

