/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android;

import android.graphics.Matrix;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.util.Size;
import boofcv.android.camera2.CameraID;
import java.util.ArrayList;
import java.util.List;

public class BoofAndroidUtils {
    public static boolean videoToDisplayMatrix(int cameraWidth, int cameraHeight, int cameraRotation, int displayWidth, int displayHeight, int displayRotation, boolean stretchToFill, Matrix imageToView) {
        boolean needToRotateView;
        int rotatedWidth = cameraWidth;
        int rotatedHeight = cameraHeight;
        int offsetX = 0;
        int offsetY = 0;
        boolean bl = needToRotateView = (0 == displayRotation || 180 == displayRotation) != (cameraRotation == 0 || cameraRotation == 180);
        if (needToRotateView) {
            rotatedWidth = cameraHeight;
            rotatedHeight = cameraWidth;
            offsetX = (rotatedWidth - rotatedHeight) / 2;
            offsetY = (rotatedHeight - rotatedWidth) / 2;
        }
        imageToView.reset();
        float scale = Math.min((float)displayWidth / (float)rotatedWidth, (float)displayHeight / (float)rotatedHeight);
        if (scale == 0.0f) {
            return false;
        }
        imageToView.postRotate((float)(-displayRotation + cameraRotation), (float)(cameraWidth / 2), (float)(cameraHeight / 2));
        imageToView.postTranslate((float)offsetX, (float)offsetY);
        imageToView.postScale(scale, scale);
        if (stretchToFill) {
            imageToView.postScale((float)displayWidth / ((float)rotatedWidth * scale), (float)displayHeight / ((float)rotatedHeight * scale));
        } else {
            imageToView.postTranslate(((float)displayWidth - (float)rotatedWidth * scale) / 2.0f, ((float)displayHeight - (float)rotatedHeight * scale) / 2.0f);
        }
        return true;
    }

    public static int selectAspectRatio(int widthTexture, int heightTexture, Size[] resolutions) {
        int bestIndex = -1;
        double bestAspect = Double.MAX_VALUE;
        double bestArea = 0.0;
        double textureAspect = widthTexture > 0 ? (double)widthTexture / (double)heightTexture : 0.0;
        for (int i = 0; i < resolutions.length; ++i) {
            double aspectScore;
            Size s = resolutions[i];
            int width = s.getWidth();
            int height = s.getHeight();
            double d = aspectScore = widthTexture > 0 ? Math.abs((double)width - (double)height * textureAspect) / (double)width : 1.0;
            if (aspectScore < bestAspect) {
                bestIndex = i;
                bestAspect = aspectScore;
                bestArea = width * height;
                continue;
            }
            if (!(Math.abs(aspectScore - bestArea) <= 1.0E-8)) continue;
            bestIndex = i;
            double area = width * height;
            if (!(area > bestArea)) continue;
            bestArea = area;
        }
        return bestIndex;
    }

    public static List<CameraID> getAllCameras(CameraManager manager) throws CameraAccessException {
        ArrayList<CameraID> allCameras = new ArrayList<CameraID>();
        block0: for (String id : manager.getCameraIdList()) {
            allCameras.add(new CameraID(id));
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(id);
            if (Build.VERSION.SDK_INT < 28) continue;
            int[] capabilities = (int[])characteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
            for (int i = 0; i < capabilities.length; ++i) {
                if (capabilities[i] != 11) continue;
                for (String physicalID : characteristics.getPhysicalCameraIds()) {
                    allCameras.add(new CameraID(physicalID, id));
                }
                continue block0;
            }
        }
        return allCameras;
    }

    public static String facingToString(Integer value) {
        String string;
        if (value == null) {
            return "null";
        }
        switch (value) {
            case 0: {
                string = "front";
                break;
            }
            case 1: {
                string = "back";
                break;
            }
            case 2: {
                string = "external";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public static String formatToString(int value) {
        Object object;
        switch (value) {
            case 1144402265: {
                object = "DEPTH16";
                break;
            }
            case 257: {
                object = "DEPTH_POINT_CLOUD";
                break;
            }
            case 1768253795: {
                object = "DEPTH_JPEG";
                break;
            }
            case 4098: {
                object = "RAW_DEPTH";
                break;
            }
            case 4099: {
                object = "RAW_DEPTH10";
                break;
            }
            case 256: {
                object = "JPEG";
                break;
            }
            case 16: {
                object = "NV16";
                break;
            }
            case 17: {
                object = "NV21";
                break;
            }
            case 4: {
                object = "RGB_565";
                break;
            }
            case 20: {
                object = "YUY2";
                break;
            }
            case 842094169: {
                object = "YV12";
                break;
            }
            case 35: {
                object = "YUV_420_888";
                break;
            }
            case 39: {
                object = "YUV_422_888";
                break;
            }
            case 40: {
                object = "YUV_444_888";
                break;
            }
            case 41: {
                object = "FLEX_RGB_888";
                break;
            }
            case 42: {
                object = "FLEX_RGB_888";
                break;
            }
            case 34: {
                object = "PRIVATE";
                break;
            }
            case 36: {
                object = "RAW_PRIVATE";
                break;
            }
            case 32: {
                object = "RAW_SENSOR";
                break;
            }
            case 37: {
                object = "RAW10";
                break;
            }
            case 38: {
                object = "RAW12";
                break;
            }
            default: {
                object = "Unk:" + value;
            }
        }
        return object;
    }
}

