/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMSerializer;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMUtils;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.FileFilterImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class VersionTagUpdater {
    public static void updateProject(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        Text textNode;
        Element pvElement;
        Element propertiesElement;
        Element profilesElement;
        Element dependenciesElement;
        Element dependencyManagementElement;
        Element versionElement;
        Text textNode2;
        Document pom = null;
        try {
            DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            pom = builder.parse(project.getFile());
        }
        catch (Exception pe) {
            throw new MojoExecutionException("Error parsing pom.", pe);
        }
        boolean modified = false;
        Element projectElement = pom.getDocumentElement();
        Element parentElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "parent"));
        if (parentElement != null && (textNode2 = (Text)(versionElement = DOMUtils.getChildElement(parentElement, new QName("http://maven.apache.org/POM/4.0.0", "version"))).getFirstChild()).getData().equals(fromVersion)) {
            versionElement.removeChild(textNode2);
            versionElement.appendChild(pom.createTextNode(toVersion));
            modified = true;
        }
        if ((versionElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "version"))) != null && (textNode2 = (Text)versionElement.getFirstChild()).getData().equals(fromVersion)) {
            versionElement.removeChild(textNode2);
            versionElement.appendChild(pom.createTextNode(toVersion));
            modified = true;
        }
        if ((dependencyManagementElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "dependencyManagement"))) != null && (dependenciesElement = DOMUtils.getChildElement(dependencyManagementElement, new QName("http://maven.apache.org/POM/4.0.0", "dependencies"))) != null) {
            for (Element dependencyElement : DOMUtils.getChildElements(dependenciesElement, new QName("http://maven.apache.org/POM/4.0.0", "dependency"))) {
                Text textNode3;
                Element versionElement2;
                Element groupElement = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "groupId"));
                String groupId = DOMUtils.getText(groupElement);
                if (!groupId.startsWith("org.bluestemsoftware") || (versionElement2 = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "version"))) == null || !(textNode3 = (Text)versionElement2.getFirstChild()).getData().equals(fromVersion)) continue;
                versionElement2.removeChild(textNode3);
                versionElement2.appendChild(pom.createTextNode(toVersion));
                modified = true;
            }
        }
        if ((dependenciesElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "dependencies"))) != null) {
            List<Element> kids = DOMUtils.getChildElements(dependenciesElement, new QName("http://maven.apache.org/POM/4.0.0", "dependency"));
            for (Element dependencyElement : kids) {
                Text textNode4;
                Element versionElement3;
                Element groupElement = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "groupId"));
                String groupId = DOMUtils.getText(groupElement);
                if (!groupId.startsWith("org.bluestemsoftware") || (versionElement3 = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "version"))) == null || !(textNode4 = (Text)versionElement3.getFirstChild()).getData().equals(fromVersion)) continue;
                versionElement3.removeChild(textNode4);
                versionElement3.appendChild(pom.createTextNode(toVersion));
                modified = true;
            }
        }
        if ((profilesElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "profiles"))) != null) {
            List<Element> kids = DOMUtils.getChildElements(profilesElement, new QName("http://maven.apache.org/POM/4.0.0", "profile"));
            for (Element profileElement : kids) {
                dependenciesElement = DOMUtils.getChildElement(profileElement, new QName("http://maven.apache.org/POM/4.0.0", "dependencies"));
                if (dependenciesElement == null) continue;
                List<Element> list = DOMUtils.getChildElements(dependenciesElement, new QName("http://maven.apache.org/POM/4.0.0", "dependency"));
                for (Element dependencyElement : list) {
                    Text textNode5;
                    Element versionElement4;
                    Element groupElement = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "groupId"));
                    String groupId = DOMUtils.getText(groupElement);
                    if (!groupId.startsWith("org.bluestemsoftware") || (versionElement4 = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "version"))) == null || !(textNode5 = (Text)versionElement4.getFirstChild()).getData().equals(fromVersion)) continue;
                    versionElement4.removeChild(textNode5);
                    versionElement4.appendChild(pom.createTextNode(toVersion));
                    modified = true;
                }
            }
        }
        if ((propertiesElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "properties"))) != null && (pvElement = DOMUtils.getChildElement(propertiesElement, new QName("http://maven.apache.org/POM/4.0.0", "partner.version"))) != null && (textNode = (Text)pvElement.getFirstChild()).getData().equals(fromVersion)) {
            pvElement.removeChild(textNode);
            pvElement.appendChild(pom.createTextNode(toVersion));
            modified = true;
        }
        if (modified) {
            try {
                FileWriter fileWriter = new FileWriter(project.getFile());
                fileWriter.write(DOMSerializer.serializeNode(pom));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception ie) {
                throw new MojoExecutionException("Error updating pom.", ie);
            }
        }
        if (!project.getArtifactId().equals("empty-project")) {
            VersionTagUpdater.updateTestPOMs(project, fromVersion, toVersion);
        }
        if (project.getArtifactId().equals("treleis-standalone-assembly")) {
            VersionTagUpdater.updateSystemPOMs(project, fromVersion, toVersion);
        }
        if (project.getArtifactId().endsWith("archetype")) {
            VersionTagUpdater.updateArchetypePOMs(project, fromVersion, toVersion);
        }
        if (project.getArtifactId().equals("treleis-standalone-trunks")) {
            VersionTagUpdater.updateBuildScript(project, fromVersion, toVersion);
        }
    }

    private static void updateTestPOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File[] suiteDirs;
        File baseDir = project.getFile().getParentFile();
        File testDir = new File(baseDir, "src/it/");
        if (!testDir.exists()) {
            return;
        }
        for (File suiteDir : suiteDirs = testDir.listFiles(new FileFilterImpl())) {
            if (!suiteDir.isDirectory()) continue;
            File pomFile = new File(suiteDir, "system/resources/treleis/etc/pom.xml");
            if (!pomFile.exists()) {
                throw new MojoExecutionException("Project " + project.getArtifactId() + " missing test POM " + pomFile.getAbsolutePath());
            }
            MavenProject temp = new MavenProject();
            temp.setFile(pomFile);
            VersionTagUpdater.updateProject(temp, fromVersion, toVersion);
        }
    }

    private static void updateBuildScript(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File baseDir = project.getFile().getParentFile();
        File buildScript = new File(baseDir, "build.bat");
        if (!buildScript.exists()) {
            throw new MojoExecutionException("Project treleis missing build script " + buildScript.getAbsolutePath());
        }
        try {
            String input = IOUtils.toString((InputStream)new FileInputStream(buildScript), (String)"UTF-8");
            if (input.contains(fromVersion)) {
                input = input.replace(fromVersion, toVersion);
                FileOutputStream out = new FileOutputStream(buildScript);
                ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes("UTF-8"));
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
                out.close();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error updating build script. " + ex);
        }
    }

    private static void updateSystemPOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File[] systemInstanceDirs;
        File baseDir = project.getFile().getParentFile();
        File systemDir = new File(baseDir, "src/main/assembly/system/");
        if (!systemDir.exists()) {
            throw new MojoExecutionException("Project treleis-standalone-assembly missing subdirectory " + systemDir.getAbsolutePath());
        }
        for (File systemInstanceDir : systemInstanceDirs = systemDir.listFiles(new FileFilterImpl())) {
            if (!systemInstanceDir.isDirectory()) continue;
            File pomFile = new File(systemInstanceDir, "etc/pom.xml");
            if (!pomFile.exists()) {
                throw new MojoExecutionException("Project treleis-standalone-assembly missing system POM " + pomFile.getAbsolutePath());
            }
            MavenProject temp = new MavenProject();
            temp.setFile(pomFile);
            VersionTagUpdater.updateProject(temp, fromVersion, toVersion);
        }
    }

    private static void updateArchetypePOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File baseDir = project.getFile().getParentFile();
        File pomFile = new File(baseDir, "src/main/resources/pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Archetype project missing file " + pomFile.getAbsolutePath());
        }
        MavenProject temp = new MavenProject();
        temp.setFile(pomFile);
        VersionTagUpdater.updateProject(temp, fromVersion, toVersion);
        pomFile = new File(baseDir, "src/main/resources/src/it/suite1/system/resources/treleis/etc/pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Archetype project missing file " + pomFile.getAbsolutePath());
        }
        temp = new MavenProject();
        temp.setFile(pomFile);
        VersionTagUpdater.updateProject(temp, fromVersion, toVersion);
    }
}

