/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.bitcoin.protocols.payments.Protos;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.utils.ExchangeRate;
import org.bitcoinj.wallet.AllowUnconfirmedCoinSelector;
import org.bitcoinj.wallet.CoinSelector;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;

public class SendRequest {
    public Transaction tx;
    public boolean emptyWallet = false;
    public Address changeAddress = null;
    public Coin feePerKb = Context.get().getFeePerKb();
    public boolean ensureMinRequiredFee = Context.get().isEnsureMinRequiredFee();
    public boolean signInputs = true;
    public KeyParameter aesKey = null;
    public CoinSelector coinSelector = null;
    public boolean shuffleOutputs = true;
    public Wallet.MissingSigsMode missingSigsMode = Wallet.MissingSigsMode.THROW;
    public ExchangeRate exchangeRate = null;
    public String memo = null;
    public boolean recipientsPayFees = false;
    boolean completed;

    public void setFeePerVkb(Coin feePerVkb) {
        this.feePerKb = feePerVkb;
    }

    public void allowUnconfirmed() {
        this.coinSelector = AllowUnconfirmedCoinSelector.get();
    }

    private SendRequest() {
    }

    public static SendRequest to(Address destination, Coin value) {
        SendRequest req = new SendRequest();
        NetworkParameters parameters = destination.getParameters();
        Preconditions.checkNotNull((Object)parameters, (Object)"Address is for an unknown network");
        req.tx = new Transaction(parameters);
        req.tx.addOutput(value, destination);
        return req;
    }

    public static SendRequest to(NetworkParameters params, ECKey destination, Coin value) {
        SendRequest req = new SendRequest();
        req.tx = new Transaction(params);
        req.tx.addOutput(value, destination);
        return req;
    }

    public static SendRequest forTx(Transaction tx) {
        SendRequest req = new SendRequest();
        req.tx = tx;
        return req;
    }

    public static SendRequest emptyWallet(Address destination) {
        SendRequest req = new SendRequest();
        NetworkParameters parameters = destination.getParameters();
        Preconditions.checkNotNull((Object)parameters, (Object)"Address is for an unknown network");
        req.tx = new Transaction(parameters);
        req.tx.addOutput(Coin.ZERO, destination);
        req.emptyWallet = true;
        return req;
    }

    public static SendRequest childPaysForParent(Wallet wallet, Transaction parentTransaction, Coin feeRaise) {
        TransactionOutput outputToSpend = null;
        for (TransactionOutput output : parentTransaction.getOutputs()) {
            if (!output.isMine(wallet) || !output.isAvailableForSpending() || !output.getValue().isGreaterThan(feeRaise)) continue;
            outputToSpend = output;
            break;
        }
        Preconditions.checkNotNull(outputToSpend, (Object)"Can't find adequately sized output that spends to us");
        Transaction tx = new Transaction(parentTransaction.getParams());
        tx.addInput(outputToSpend);
        tx.addOutput(outputToSpend.getValue().subtract(feeRaise), wallet.freshAddress(KeyChain.KeyPurpose.CHANGE));
        tx.setPurpose(Transaction.Purpose.RAISE_FEE);
        SendRequest req = SendRequest.forTx(tx);
        req.completed = true;
        return req;
    }

    public SendRequest fromPaymentDetails(Protos.PaymentDetails paymentDetails) {
        if (paymentDetails.hasMemo()) {
            this.memo = paymentDetails.getMemo();
        }
        return this;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        helper.add("emptyWallet", this.emptyWallet);
        helper.add("changeAddress", (Object)this.changeAddress);
        helper.add("feePerKb", (Object)this.feePerKb);
        helper.add("ensureMinRequiredFee", this.ensureMinRequiredFee);
        helper.add("signInputs", this.signInputs);
        helper.add("aesKey", (Object)(this.aesKey != null ? "set" : null));
        helper.add("coinSelector", (Object)this.coinSelector);
        helper.add("shuffleOutputs", this.shuffleOutputs);
        helper.add("recipientsPayFees", this.recipientsPayFees);
        return helper.toString();
    }
}

