/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.StoredUndoableBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutputChanges;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.UTXOProviderException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.FullPrunedBlockStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseFullPrunedBlockStore
implements FullPrunedBlockStore {
    private static final Logger log = LoggerFactory.getLogger(DatabaseFullPrunedBlockStore.class);
    private static final String CHAIN_HEAD_SETTING = "chainhead";
    private static final String VERIFIED_CHAIN_HEAD_SETTING = "verifiedchainhead";
    private static final String VERSION_SETTING = "version";
    private static final String DROP_SETTINGS_TABLE = "DROP TABLE settings";
    private static final String DROP_HEADERS_TABLE = "DROP TABLE headers";
    private static final String DROP_UNDOABLE_TABLE = "DROP TABLE undoableblocks";
    private static final String DROP_OPEN_OUTPUT_TABLE = "DROP TABLE openoutputs";
    private static final String SELECT_SETTINGS_SQL = "SELECT value FROM settings WHERE name = ?";
    private static final String INSERT_SETTINGS_SQL = "INSERT INTO settings(name, value) VALUES(?, ?)";
    private static final String UPDATE_SETTINGS_SQL = "UPDATE settings SET value = ? WHERE name = ?";
    private static final String SELECT_HEADERS_SQL = "SELECT chainwork, height, header, wasundoable FROM headers WHERE hash = ?";
    private static final String INSERT_HEADERS_SQL = "INSERT INTO headers(hash, chainwork, height, header, wasundoable) VALUES(?, ?, ?, ?, ?)";
    private static final String UPDATE_HEADERS_SQL = "UPDATE headers SET wasundoable=? WHERE hash=?";
    private static final String SELECT_UNDOABLEBLOCKS_SQL = "SELECT txoutchanges, transactions FROM undoableblocks WHERE hash = ?";
    private static final String INSERT_UNDOABLEBLOCKS_SQL = "INSERT INTO undoableblocks(hash, height, txoutchanges, transactions) VALUES(?, ?, ?, ?)";
    private static final String UPDATE_UNDOABLEBLOCKS_SQL = "UPDATE undoableblocks SET txoutchanges=?, transactions=? WHERE hash = ?";
    private static final String DELETE_UNDOABLEBLOCKS_SQL = "DELETE FROM undoableblocks WHERE height <= ?";
    private static final String SELECT_OPENOUTPUTS_SQL = "SELECT height, value, scriptbytes, coinbase, toaddress, addresstargetable FROM openoutputs WHERE hash = ? AND index = ?";
    private static final String SELECT_OPENOUTPUTS_COUNT_SQL = "SELECT COUNT(*) FROM openoutputs WHERE hash = ?";
    private static final String INSERT_OPENOUTPUTS_SQL = "INSERT INTO openoutputs (hash, index, height, value, scriptbytes, toaddress, addresstargetable, coinbase) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_OPENOUTPUTS_SQL = "DELETE FROM openoutputs WHERE hash = ? AND index = ?";
    private static final String SELECT_DUMP_SETTINGS_SQL = "SELECT name, value FROM settings";
    private static final String SELECT_DUMP_HEADERS_SQL = "SELECT chainwork, header FROM headers";
    private static final String SELECT_DUMP_UNDOABLEBLOCKS_SQL = "SELECT txoutchanges, transactions FROM undoableblocks";
    private static final String SELECT_DUMP_OPENOUTPUTS_SQL = "SELECT value, scriptbytes FROM openoutputs";
    private static final String SELECT_TRANSACTION_OUTPUTS_SQL = "SELECT hash, value, scriptbytes, height, index, coinbase, toaddress, addresstargetable FROM openoutputs where toaddress = ?";
    private static final String SELECT_BALANCE_SQL = "select sum(value) from openoutputs where toaddress = ?";
    private static final String SELECT_CHECK_TABLES_EXIST_SQL = "SELECT * FROM settings WHERE 1 = 2";
    private static final String SELECT_COMPATIBILITY_COINBASE_SQL = "SELECT coinbase FROM openoutputs WHERE 1 = 2";
    protected Sha256Hash chainHeadHash;
    protected StoredBlock chainHeadBlock;
    protected Sha256Hash verifiedChainHeadHash;
    protected StoredBlock verifiedChainHeadBlock;
    protected NetworkParameters params;
    protected ThreadLocal<Connection> conn;
    protected List<Connection> allConnections;
    protected String connectionURL;
    protected int fullStoreDepth;
    protected String username;
    protected String password;
    protected String schemaName;

    public DatabaseFullPrunedBlockStore(NetworkParameters params, String connectionURL, int fullStoreDepth, @Nullable String username, @Nullable String password, @Nullable String schemaName) throws BlockStoreException {
        this.params = params;
        this.fullStoreDepth = fullStoreDepth;
        this.connectionURL = connectionURL;
        this.schemaName = schemaName;
        this.username = username;
        this.password = password;
        this.conn = new ThreadLocal();
        this.allConnections = new LinkedList<Connection>();
        try {
            Class.forName(this.getDatabaseDriverClass());
            log.info(this.getDatabaseDriverClass() + " loaded. ");
        }
        catch (ClassNotFoundException e) {
            log.error("check CLASSPATH for database driver jar ", (Throwable)e);
        }
        this.maybeConnect();
        try {
            if (!this.tablesExists()) {
                this.createTables();
            } else {
                this.checkCompatibility();
            }
            this.initFromDatabase();
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    protected abstract String getDatabaseDriverClass();

    protected abstract List<String> getCreateSchemeSQL();

    protected abstract List<String> getCreateTablesSQL();

    protected abstract List<String> getCreateIndexesSQL();

    protected abstract String getDuplicateKeyErrorCode();

    protected String getBalanceSelectSQL() {
        return SELECT_BALANCE_SQL;
    }

    protected String getTablesExistSQL() {
        return SELECT_CHECK_TABLES_EXIST_SQL;
    }

    protected List<String> getCompatibilitySQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(SELECT_COMPATIBILITY_COINBASE_SQL);
        return sqlStatements;
    }

    protected String getTransactionOutputSelectSQL() {
        return SELECT_TRANSACTION_OUTPUTS_SQL;
    }

    protected List<String> getDropTablesSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(DROP_SETTINGS_TABLE);
        sqlStatements.add(DROP_HEADERS_TABLE);
        sqlStatements.add(DROP_UNDOABLE_TABLE);
        sqlStatements.add(DROP_OPEN_OUTPUT_TABLE);
        return sqlStatements;
    }

    protected String getSelectSettingsSQL() {
        return SELECT_SETTINGS_SQL;
    }

    protected String getInsertSettingsSQL() {
        return INSERT_SETTINGS_SQL;
    }

    protected String getUpdateSettingsSLQ() {
        return UPDATE_SETTINGS_SQL;
    }

    protected String getSelectHeadersSQL() {
        return SELECT_HEADERS_SQL;
    }

    protected String getInsertHeadersSQL() {
        return INSERT_HEADERS_SQL;
    }

    protected String getUpdateHeadersSQL() {
        return UPDATE_HEADERS_SQL;
    }

    protected String getSelectUndoableBlocksSQL() {
        return SELECT_UNDOABLEBLOCKS_SQL;
    }

    protected String getInsertUndoableBlocksSQL() {
        return INSERT_UNDOABLEBLOCKS_SQL;
    }

    protected String getUpdateUndoableBlocksSQL() {
        return UPDATE_UNDOABLEBLOCKS_SQL;
    }

    protected String getDeleteUndoableBlocksSQL() {
        return DELETE_UNDOABLEBLOCKS_SQL;
    }

    protected String getSelectOpenoutputsSQL() {
        return SELECT_OPENOUTPUTS_SQL;
    }

    protected String getSelectOpenoutputsCountSQL() {
        return SELECT_OPENOUTPUTS_COUNT_SQL;
    }

    protected String getInsertOpenoutputsSQL() {
        return INSERT_OPENOUTPUTS_SQL;
    }

    protected String getDeleteOpenoutputsSQL() {
        return DELETE_OPENOUTPUTS_SQL;
    }

    protected String getSelectSettingsDumpSQL() {
        return SELECT_DUMP_SETTINGS_SQL;
    }

    protected String getSelectHeadersDumpSQL() {
        return SELECT_DUMP_HEADERS_SQL;
    }

    protected String getSelectUndoableblocksDumpSQL() {
        return SELECT_DUMP_UNDOABLEBLOCKS_SQL;
    }

    protected String getSelectopenoutputsDumpSQL() {
        return SELECT_DUMP_OPENOUTPUTS_SQL;
    }

    protected final synchronized void maybeConnect() throws BlockStoreException {
        try {
            if (this.conn.get() != null && !this.conn.get().isClosed()) {
                return;
            }
            if (this.username == null || this.password == null) {
                this.conn.set(DriverManager.getConnection(this.connectionURL));
            } else {
                Properties props = new Properties();
                props.setProperty("user", this.username);
                props.setProperty("password", this.password);
                this.conn.set(DriverManager.getConnection(this.connectionURL, props));
            }
            this.allConnections.add(this.conn.get());
            Connection connection = this.conn.get();
            if (this.schemaName != null) {
                Statement s = connection.createStatement();
                for (String sql : this.getCreateSchemeSQL()) {
                    s.execute(sql);
                }
            }
            log.info("Made a new connection to database " + this.connectionURL);
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
    }

    @Override
    public synchronized void close() {
        for (Connection conn : this.allConnections) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
                conn.close();
                if (conn != this.conn.get()) continue;
                this.conn.set(null);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.allConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tablesExists() throws SQLException {
        Statement ps = null;
        try {
            ps = this.conn.get().prepareStatement(this.getTablesExistSQL());
            ResultSet results = ps.executeQuery();
            results.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ps != null && !ps.isClosed()) {
                ps.close();
            }
        }
    }

    private void checkCompatibility() throws SQLException, BlockStoreException {
        for (String sql : this.getCompatibilitySQL()) {
            Statement ps = null;
            try {
                ps = this.conn.get().prepareStatement(sql);
                ResultSet results = ps.executeQuery();
                results.close();
            }
            catch (SQLException ex) {
                throw new BlockStoreException("Database block store is not compatible with the current release.  See bitcoinj release notes for further information: " + ex.getMessage());
            }
            finally {
                if (ps == null || ps.isClosed()) continue;
                ps.close();
            }
        }
    }

    private void createTables() throws SQLException, BlockStoreException {
        Statement s = this.conn.get().createStatement();
        for (String sql : this.getCreateTablesSQL()) {
            if (log.isDebugEnabled()) {
                log.debug("DatabaseFullPrunedBlockStore : CREATE table [SQL= {0}]", (Object)sql);
            }
            s.executeUpdate(sql);
        }
        for (String sql : this.getCreateIndexesSQL()) {
            if (log.isDebugEnabled()) {
                log.debug("DatabaseFullPrunedBlockStore : CREATE index [SQL= {0}]", (Object)sql);
            }
            s.executeUpdate(sql);
        }
        s.close();
        PreparedStatement ps = this.conn.get().prepareStatement(this.getInsertSettingsSQL());
        ps.setString(1, CHAIN_HEAD_SETTING);
        ps.setNull(2, -2);
        ps.execute();
        ps.setString(1, VERIFIED_CHAIN_HEAD_SETTING);
        ps.setNull(2, -2);
        ps.execute();
        ps.setString(1, VERSION_SETTING);
        ps.setBytes(2, "03".getBytes());
        ps.execute();
        ps.close();
        this.createNewStore(this.params);
    }

    private void createNewStore(NetworkParameters params) throws BlockStoreException {
        try {
            StoredBlock storedGenesisHeader = new StoredBlock(params.getGenesisBlock().cloneAsHeader(), params.getGenesisBlock().getWork(), 0);
            LinkedList<Transaction> genesisTransactions = new LinkedList<Transaction>();
            StoredUndoableBlock storedGenesis = new StoredUndoableBlock(params.getGenesisBlock().getHash(), genesisTransactions);
            this.put(storedGenesisHeader, storedGenesis);
            this.setChainHead(storedGenesisHeader);
            this.setVerifiedChainHead(storedGenesisHeader);
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
    }

    private void initFromDatabase() throws SQLException, BlockStoreException {
        PreparedStatement ps = this.conn.get().prepareStatement(this.getSelectSettingsSQL());
        ps.setString(1, CHAIN_HEAD_SETTING);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            throw new BlockStoreException("corrupt database block store - no chain head pointer");
        }
        Sha256Hash hash = Sha256Hash.wrap(rs.getBytes(1));
        rs.close();
        this.chainHeadBlock = this.get(hash);
        this.chainHeadHash = hash;
        if (this.chainHeadBlock == null) {
            throw new BlockStoreException("corrupt database block store - head block not found");
        }
        ps.setString(1, VERIFIED_CHAIN_HEAD_SETTING);
        rs = ps.executeQuery();
        if (!rs.next()) {
            throw new BlockStoreException("corrupt database block store - no verified chain head pointer");
        }
        hash = Sha256Hash.wrap(rs.getBytes(1));
        rs.close();
        ps.close();
        this.verifiedChainHeadBlock = this.get(hash);
        this.verifiedChainHeadHash = hash;
        if (this.verifiedChainHeadBlock == null) {
            throw new BlockStoreException("corrupt database block store - verified head block not found");
        }
    }

    protected void putUpdateStoredBlock(StoredBlock storedBlock, boolean wasUndoable) throws SQLException {
        try {
            PreparedStatement s = this.conn.get().prepareStatement(this.getInsertHeadersSQL());
            byte[] hashBytes = new byte[28];
            System.arraycopy(storedBlock.getHeader().getHash().getBytes(), 4, hashBytes, 0, 28);
            s.setBytes(1, hashBytes);
            s.setBytes(2, storedBlock.getChainWork().toByteArray());
            s.setInt(3, storedBlock.getHeight());
            s.setBytes(4, storedBlock.getHeader().cloneAsHeader().unsafeBitcoinSerialize());
            s.setBoolean(5, wasUndoable);
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals(this.getDuplicateKeyErrorCode()) || !wasUndoable) {
                throw e;
            }
            PreparedStatement s = this.conn.get().prepareStatement(this.getUpdateHeadersSQL());
            s.setBoolean(1, true);
            byte[] hashBytes = new byte[28];
            System.arraycopy(storedBlock.getHeader().getHash().getBytes(), 4, hashBytes, 0, 28);
            s.setBytes(2, hashBytes);
            s.executeUpdate();
            s.close();
        }
    }

    @Override
    public void put(StoredBlock storedBlock) throws BlockStoreException {
        this.maybeConnect();
        try {
            this.putUpdateStoredBlock(storedBlock, false);
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public void put(StoredBlock storedBlock, StoredUndoableBlock undoableBlock) throws BlockStoreException {
        this.maybeConnect();
        byte[] hashBytes = new byte[28];
        System.arraycopy(storedBlock.getHeader().getHash().getBytes(), 4, hashBytes, 0, 28);
        int height = storedBlock.getHeight();
        byte[] transactions = null;
        byte[] txOutChanges = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (undoableBlock.getTxOutChanges() != null) {
                undoableBlock.getTxOutChanges().serializeToStream(bos);
                txOutChanges = bos.toByteArray();
            } else {
                int numTxn = undoableBlock.getTransactions().size();
                Utils.uint32ToByteStreamLE(numTxn, bos);
                for (Transaction tx : undoableBlock.getTransactions()) {
                    tx.bitcoinSerialize(bos);
                }
                transactions = bos.toByteArray();
            }
            bos.close();
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
        try {
            try {
                PreparedStatement s = this.conn.get().prepareStatement(this.getInsertUndoableBlocksSQL());
                s.setBytes(1, hashBytes);
                s.setInt(2, height);
                if (transactions == null) {
                    s.setBytes(3, txOutChanges);
                    s.setNull(4, -2);
                } else {
                    s.setNull(3, -2);
                    s.setBytes(4, transactions);
                }
                s.executeUpdate();
                s.close();
                try {
                    this.putUpdateStoredBlock(storedBlock, true);
                }
                catch (SQLException e) {
                    throw new BlockStoreException(e);
                }
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals(this.getDuplicateKeyErrorCode())) {
                    throw new BlockStoreException(e);
                }
                PreparedStatement s = this.conn.get().prepareStatement(this.getUpdateUndoableBlocksSQL());
                s.setBytes(3, hashBytes);
                if (transactions == null) {
                    s.setBytes(1, txOutChanges);
                    s.setNull(2, -2);
                } else {
                    s.setNull(1, -2);
                    s.setBytes(2, transactions);
                }
                s.executeUpdate();
                s.close();
            }
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
    }

    public StoredBlock get(Sha256Hash hash, boolean wasUndoableOnly) throws BlockStoreException {
        if (this.chainHeadHash != null && this.chainHeadHash.equals(hash)) {
            return this.chainHeadBlock;
        }
        if (this.verifiedChainHeadHash != null && this.verifiedChainHeadHash.equals(hash)) {
            return this.verifiedChainHeadBlock;
        }
        this.maybeConnect();
        Statement s = null;
        try {
            StoredBlock stored;
            s = this.conn.get().prepareStatement(this.getSelectHeadersSQL());
            byte[] hashBytes = new byte[28];
            System.arraycopy(hash.getBytes(), 4, hashBytes, 0, 28);
            s.setBytes(1, hashBytes);
            ResultSet results = s.executeQuery();
            if (!results.next()) {
                StoredBlock storedBlock = null;
                return storedBlock;
            }
            if (wasUndoableOnly && !results.getBoolean(4)) {
                StoredBlock storedBlock = null;
                return storedBlock;
            }
            BigInteger chainWork = new BigInteger(results.getBytes(1));
            int height = results.getInt(2);
            Block b = this.params.getDefaultSerializer().makeBlock(results.getBytes(3));
            b.verifyHeader();
            StoredBlock storedBlock = stored = new StoredBlock(b, chainWork, height);
            return storedBlock;
        }
        catch (SQLException | VerificationException e) {
            throw new BlockStoreException(e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException("Failed to close PreparedStatement");
                }
            }
        }
    }

    @Override
    public StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        return this.get(hash, false);
    }

    @Override
    public StoredBlock getOnceUndoableStoredBlock(Sha256Hash hash) throws BlockStoreException {
        return this.get(hash, true);
    }

    @Override
    public StoredUndoableBlock getUndoBlock(Sha256Hash hash) throws BlockStoreException {
        this.maybeConnect();
        Statement s = null;
        try {
            StoredUndoableBlock block;
            s = this.conn.get().prepareStatement(this.getSelectUndoableBlocksSQL());
            byte[] hashBytes = new byte[28];
            System.arraycopy(hash.getBytes(), 4, hashBytes, 0, 28);
            s.setBytes(1, hashBytes);
            ResultSet results = s.executeQuery();
            if (!results.next()) {
                StoredUndoableBlock storedUndoableBlock = null;
                return storedUndoableBlock;
            }
            byte[] txOutChanges = results.getBytes(1);
            byte[] transactions = results.getBytes(2);
            if (txOutChanges == null) {
                int numTxn = (int)Utils.readUint32(transactions, 0);
                int offset = 4;
                LinkedList<Transaction> transactionList = new LinkedList<Transaction>();
                for (int i = 0; i < numTxn; ++i) {
                    Transaction tx = this.params.getDefaultSerializer().makeTransaction(transactions, offset);
                    transactionList.add(tx);
                    offset += tx.getMessageSize();
                }
                block = new StoredUndoableBlock(hash, transactionList);
            } else {
                TransactionOutputChanges outChangesObject = new TransactionOutputChanges(new ByteArrayInputStream(txOutChanges));
                block = new StoredUndoableBlock(hash, outChangesObject);
            }
            StoredUndoableBlock storedUndoableBlock = block;
            return storedUndoableBlock;
        }
        catch (IOException | ClassCastException | NullPointerException | SQLException | ProtocolException e) {
            throw new BlockStoreException(e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException("Failed to close PreparedStatement");
                }
            }
        }
    }

    @Override
    public StoredBlock getChainHead() throws BlockStoreException {
        return this.chainHeadBlock;
    }

    @Override
    public void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        Sha256Hash hash;
        this.chainHeadHash = hash = chainHead.getHeader().getHash();
        this.chainHeadBlock = chainHead;
        this.maybeConnect();
        try {
            PreparedStatement s = this.conn.get().prepareStatement(this.getUpdateSettingsSLQ());
            s.setString(2, CHAIN_HEAD_SETTING);
            s.setBytes(1, hash.getBytes());
            s.executeUpdate();
            s.close();
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
    }

    @Override
    public StoredBlock getVerifiedChainHead() throws BlockStoreException {
        return this.verifiedChainHeadBlock;
    }

    @Override
    public void setVerifiedChainHead(StoredBlock chainHead) throws BlockStoreException {
        Sha256Hash hash;
        this.verifiedChainHeadHash = hash = chainHead.getHeader().getHash();
        this.verifiedChainHeadBlock = chainHead;
        this.maybeConnect();
        try {
            PreparedStatement s = this.conn.get().prepareStatement(this.getUpdateSettingsSLQ());
            s.setString(2, VERIFIED_CHAIN_HEAD_SETTING);
            s.setBytes(1, hash.getBytes());
            s.executeUpdate();
            s.close();
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
        if (this.chainHeadBlock.getHeight() < chainHead.getHeight()) {
            this.setChainHead(chainHead);
        }
        this.removeUndoableBlocksWhereHeightIsLessThan(chainHead.getHeight() - this.fullStoreDepth);
    }

    private void removeUndoableBlocksWhereHeightIsLessThan(int height) throws BlockStoreException {
        try {
            PreparedStatement s = this.conn.get().prepareStatement(this.getDeleteUndoableBlocksSQL());
            s.setInt(1, height);
            if (log.isDebugEnabled()) {
                log.debug("Deleting undoable undoable block with height <= " + height);
            }
            s.executeUpdate();
            s.close();
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
    }

    @Override
    public UTXO getTransactionOutput(Sha256Hash hash, long index) throws BlockStoreException {
        this.maybeConnect();
        Statement s = null;
        try {
            UTXO txout;
            s = this.conn.get().prepareStatement(this.getSelectOpenoutputsSQL());
            s.setBytes(1, hash.getBytes());
            s.setInt(2, (int)index);
            ResultSet results = s.executeQuery();
            if (!results.next()) {
                UTXO uTXO = null;
                return uTXO;
            }
            int height = results.getInt(1);
            Coin value = Coin.valueOf(results.getLong(2));
            byte[] scriptBytes = results.getBytes(3);
            boolean coinbase = results.getBoolean(4);
            String address = results.getString(5);
            UTXO uTXO = txout = new UTXO(hash, index, value, height, coinbase, new Script(scriptBytes), address);
            return uTXO;
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException("Failed to close PreparedStatement");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        this.maybeConnect();
        Statement s = null;
        try {
            s = this.conn.get().prepareStatement(this.getInsertOpenoutputsSQL());
            s.setBytes(1, out.getHash().getBytes());
            s.setInt(2, (int)out.getIndex());
            s.setInt(3, out.getHeight());
            s.setLong(4, out.getValue().value);
            s.setBytes(5, out.getScript().getProgram());
            s.setString(6, out.getAddress());
            Script.ScriptType scriptType = out.getScript().getScriptType();
            s.setInt(7, scriptType != null ? scriptType.id : 0);
            s.setBoolean(8, out.isCoinbase());
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals(this.getDuplicateKeyErrorCode())) {
                throw new BlockStoreException(e);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException(e);
                }
            }
        }
    }

    @Override
    public void removeUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        this.maybeConnect();
        if (this.getTransactionOutput(out.getHash(), out.getIndex()) == null) {
            throw new BlockStoreException("Tried to remove a UTXO from DatabaseFullPrunedBlockStore that it didn't have!");
        }
        try {
            PreparedStatement s = this.conn.get().prepareStatement(this.getDeleteOpenoutputsSQL());
            s.setBytes(1, out.getHash().getBytes());
            s.setInt(2, (int)out.getIndex());
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public void beginDatabaseBatchWrite() throws BlockStoreException {
        this.maybeConnect();
        if (log.isDebugEnabled()) {
            log.debug("Starting database batch write with connection: " + this.conn.get().toString());
        }
        try {
            this.conn.get().setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public void commitDatabaseBatchWrite() throws BlockStoreException {
        this.maybeConnect();
        if (log.isDebugEnabled()) {
            log.debug("Committing database batch write with connection: " + this.conn.get().toString());
        }
        try {
            this.conn.get().commit();
            this.conn.get().setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public void abortDatabaseBatchWrite() throws BlockStoreException {
        this.maybeConnect();
        if (log.isDebugEnabled()) {
            log.debug("Rollback database batch write with connection: " + this.conn.get().toString());
        }
        try {
            if (!this.conn.get().getAutoCommit()) {
                this.conn.get().rollback();
                this.conn.get().setAutoCommit(true);
            } else {
                log.warn("Warning: Rollback attempt without transaction");
            }
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public boolean hasUnspentOutputs(Sha256Hash hash, int numOutputs) throws BlockStoreException {
        this.maybeConnect();
        Statement s = null;
        try {
            s = this.conn.get().prepareStatement(this.getSelectOpenoutputsCountSQL());
            s.setBytes(1, hash.getBytes());
            ResultSet results = s.executeQuery();
            if (!results.next()) {
                throw new BlockStoreException("Got no results from a COUNT(*) query");
            }
            int count = results.getInt(1);
            boolean bl = count != 0;
            return bl;
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException("Failed to close PreparedStatement");
                }
            }
        }
    }

    @Override
    public NetworkParameters getParams() {
        return this.params;
    }

    @Override
    public int getChainHeadHeight() throws UTXOProviderException {
        try {
            return this.getVerifiedChainHead().getHeight();
        }
        catch (BlockStoreException e) {
            throw new UTXOProviderException(e);
        }
    }

    public void resetStore() throws BlockStoreException {
        this.maybeConnect();
        try {
            this.deleteStore();
            this.createTables();
            this.initFromDatabase();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteStore() throws BlockStoreException {
        this.maybeConnect();
        try {
            Statement s = this.conn.get().createStatement();
            for (String sql : this.getDropTablesSQL()) {
                s.execute(sql);
            }
            s.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BigInteger calculateBalanceForAddress(Address address) throws BlockStoreException {
        this.maybeConnect();
        Statement s = null;
        try {
            s = this.conn.get().prepareStatement(this.getBalanceSelectSQL());
            s.setString(1, address.toString());
            ResultSet rs = s.executeQuery();
            BigInteger balance = BigInteger.ZERO;
            if (rs.next()) {
                BigInteger bigInteger = BigInteger.valueOf(rs.getLong(1));
                return bigInteger;
            }
            BigInteger bigInteger = balance;
            return bigInteger;
        }
        catch (SQLException ex) {
            throw new BlockStoreException(ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new BlockStoreException("Could not close statement");
                }
            }
        }
    }

    @Override
    public List<UTXO> getOpenTransactionOutputs(List<ECKey> keys) throws UTXOProviderException {
        Statement s = null;
        ArrayList<UTXO> outputs = new ArrayList<UTXO>();
        try {
            this.maybeConnect();
            s = this.conn.get().prepareStatement(this.getTransactionOutputSelectSQL());
            for (ECKey key : keys) {
                s.setString(1, LegacyAddress.fromKey(this.params, key).toString());
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    Sha256Hash hash = Sha256Hash.wrap(rs.getBytes(1));
                    Coin amount = Coin.valueOf(rs.getLong(2));
                    byte[] scriptBytes = rs.getBytes(3);
                    int height = rs.getInt(4);
                    int index = rs.getInt(5);
                    boolean coinbase = rs.getBoolean(6);
                    String toAddress = rs.getString(7);
                    UTXO output = new UTXO(hash, index, amount, height, coinbase, new Script(scriptBytes), toAddress);
                    outputs.add(output);
                }
            }
            ArrayList<UTXO> arrayList = outputs;
            return arrayList;
        }
        catch (SQLException | BlockStoreException ex) {
            throw new UTXOProviderException(ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new UTXOProviderException("Could not close statement", e);
                }
            }
        }
    }

    public void dumpSizes() throws SQLException, BlockStoreException {
        this.maybeConnect();
        Statement s = this.conn.get().createStatement();
        long size = 0L;
        long totalSize = 0L;
        int count = 0;
        ResultSet rs = s.executeQuery(this.getSelectSettingsDumpSQL());
        while (rs.next()) {
            size += (long)rs.getString(1).length();
            size += (long)rs.getBytes(2).length;
            ++count;
        }
        rs.close();
        System.out.printf(Locale.US, "Settings size: %d, count: %d, average size: %f%n", size, count, (double)size / (double)count);
        totalSize += size;
        size = 0L;
        count = 0;
        rs = s.executeQuery(this.getSelectHeadersDumpSQL());
        while (rs.next()) {
            size += 28L;
            size += (long)rs.getBytes(1).length;
            size += 4L;
            size += (long)rs.getBytes(2).length;
            ++count;
        }
        rs.close();
        System.out.printf(Locale.US, "Headers size: %d, count: %d, average size: %f%n", size, count, (double)size / (double)count);
        totalSize += size;
        size = 0L;
        count = 0;
        rs = s.executeQuery(this.getSelectUndoableblocksDumpSQL());
        while (rs.next()) {
            size += 28L;
            size += 4L;
            byte[] txOutChanges = rs.getBytes(1);
            byte[] transactions = rs.getBytes(2);
            size = txOutChanges == null ? (size += (long)transactions.length) : (size += (long)txOutChanges.length);
            ++count;
        }
        rs.close();
        System.out.printf(Locale.US, "Undoable Blocks size: %d, count: %d, average size: %f%n", size, count, (double)size / (double)count);
        totalSize += size;
        size = 0L;
        count = 0;
        long scriptSize = 0L;
        rs = s.executeQuery(this.getSelectopenoutputsDumpSQL());
        while (rs.next()) {
            size += 32L;
            size += 4L;
            size += 4L;
            size += (long)rs.getBytes(1).length;
            size += (long)rs.getBytes(2).length;
            scriptSize += (long)rs.getBytes(2).length;
            ++count;
        }
        rs.close();
        System.out.printf(Locale.US, "Open Outputs size: %d, count: %d, average size: %f, average script size: %f (%d in id indexes)%n", size, count, (double)size / (double)count, (double)scriptSize / (double)count, count * 8);
        System.out.println("Total Size: " + (totalSize += size));
        s.close();
    }
}

