/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;

public class FeeFilterMessage
extends Message {
    private Coin feeRate;

    public FeeFilterMessage(NetworkParameters params, byte[] payloadBytes, BitcoinSerializer serializer, int length) {
        super(params, payloadBytes, 0, serializer, length);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        super.bitcoinSerializeToStream(stream);
        Utils.uint64ToByteStreamLE(BigInteger.valueOf(this.feeRate.value), stream);
    }

    @Override
    protected void parse() throws ProtocolException {
        this.feeRate = Coin.ofSat(this.readUint64().longValue());
    }

    public Coin getFeeRate() {
        return this.feeRate;
    }

    public String toString() {
        return "feefilter: " + this.feeRate.toFriendlyString() + "/kB";
    }
}

