/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.Utils;
import org.bitcoinj.protocols.channels.ClientState;
import org.bitcoinj.protocols.channels.StoredClientChannel;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPaymentChannelClientStates
implements WalletExtension {
    private static final Logger log = LoggerFactory.getLogger(StoredPaymentChannelClientStates.class);
    static final String EXTENSION_ID = StoredPaymentChannelClientStates.class.getName();
    static final int MAX_SECONDS_TO_WAIT_FOR_BROADCASTER_TO_BE_SET = 10;
    @GuardedBy(value="lock")
    @VisibleForTesting
    final HashMultimap<Sha256Hash, StoredClientChannel> mapChannels = HashMultimap.create();
    @VisibleForTesting
    final Timer channelTimeoutHandler = new Timer(true);
    private Wallet containingWallet;
    private final SettableFuture<TransactionBroadcaster> announcePeerGroupFuture = SettableFuture.create();
    protected final ReentrantLock lock = Threading.lock("StoredPaymentChannelClientStates");

    public StoredPaymentChannelClientStates(@Nullable Wallet containingWallet, TransactionBroadcaster announcePeerGroup) {
        this.setTransactionBroadcaster(announcePeerGroup);
        this.containingWallet = containingWallet;
    }

    public StoredPaymentChannelClientStates(@Nullable Wallet containingWallet) {
        this.containingWallet = containingWallet;
    }

    public final void setTransactionBroadcaster(TransactionBroadcaster transactionBroadcaster) {
        this.announcePeerGroupFuture.set(Preconditions.checkNotNull((Object)transactionBroadcaster));
    }

    @Nullable
    public static StoredPaymentChannelClientStates getFromWallet(Wallet wallet) {
        return (StoredPaymentChannelClientStates)wallet.getExtensions().get(EXTENSION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coin getBalanceForServer(Sha256Hash id) {
        Coin balance = Coin.ZERO;
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            Object object = setChannels.iterator();
            while (object.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)object.next();
                synchronized (storedClientChannel) {
                    if (channel.close != null) {
                        continue;
                    }
                    balance = balance.add(channel.valueToMe);
                }
            }
            object = balance;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSecondsUntilExpiry(Sha256Hash id) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            long nowSeconds = Utils.currentTimeSeconds();
            int earliestTime = Integer.MAX_VALUE;
            Iterator iterator = setChannels.iterator();
            while (iterator.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)iterator.next();
                synchronized (storedClientChannel) {
                    if (channel.expiryTimeSeconds() > nowSeconds) {
                        earliestTime = Math.min(earliestTime, (int)channel.expiryTimeSeconds());
                    }
                }
            }
            long l = earliestTime == Integer.MAX_VALUE ? 0L : (long)earliestTime - nowSeconds;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    StoredClientChannel getUsableChannelForServerID(Sha256Hash id) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            Iterator iterator = setChannels.iterator();
            while (iterator.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)iterator.next();
                synchronized (storedClientChannel) {
                    log.info("Considering channel {} contract {}", (Object)channel.hashCode(), (Object)channel.contract.getHash());
                    if (channel.close != null || channel.valueToMe.equals(Coin.ZERO)) {
                        log.info("  ... but is closed or empty");
                        continue;
                    }
                    if (!channel.active) {
                        log.info("  ... activating");
                        channel.active = true;
                        StoredClientChannel storedClientChannel2 = channel;
                        return storedClientChannel2;
                    }
                    log.info("  ... but is already active");
                }
            }
            return null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StoredClientChannel getChannel(Sha256Hash id, Sha256Hash contractHash) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            for (StoredClientChannel channel : setChannels) {
                if (!channel.contract.getHash().equals(contractHash)) continue;
                StoredClientChannel storedClientChannel = channel;
                return storedClientChannel;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Multimap<Sha256Hash, StoredClientChannel> getChannelMap() {
        this.lock.lock();
        try {
            ImmutableMultimap immutableMultimap = ImmutableMultimap.copyOf(this.mapChannels);
            return immutableMultimap;
        }
        finally {
            this.lock.unlock();
        }
    }

    void updatedChannel(StoredClientChannel channel) {
        log.info("Stored client channel {} was updated", (Object)channel.hashCode());
        this.containingWallet.addOrUpdateExtension(this);
    }

    void putChannel(StoredClientChannel channel) {
        this.putChannel(channel, true);
    }

    private void putChannel(final StoredClientChannel channel, boolean updateWallet) {
        this.lock.lock();
        try {
            this.mapChannels.put((Object)channel.id, (Object)channel);
            this.channelTimeoutHandler.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        TransactionBroadcaster announcePeerGroup = StoredPaymentChannelClientStates.this.getAnnouncePeerGroup();
                        StoredPaymentChannelClientStates.this.removeChannel(channel);
                        announcePeerGroup.broadcastTransaction(channel.contract);
                        announcePeerGroup.broadcastTransaction(channel.refund);
                    }
                    catch (Exception e) {
                        log.error("Auto-closing channel failed", (Throwable)e);
                    }
                }
            }, new Date(channel.expiryTimeSeconds() * 1000L + (System.currentTimeMillis() - Utils.currentTimeMillis())));
        }
        finally {
            this.lock.unlock();
        }
        if (updateWallet) {
            this.updatedChannel(channel);
        }
    }

    private TransactionBroadcaster getAnnouncePeerGroup() {
        try {
            return (TransactionBroadcaster)this.announcePeerGroupFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            String err = "Transaction broadcaster not set";
            log.error(err);
            throw new RuntimeException(err, e);
        }
    }

    void removeChannel(StoredClientChannel channel) {
        this.lock.lock();
        try {
            this.mapChannels.remove((Object)channel.id, (Object)channel);
        }
        finally {
            this.lock.unlock();
        }
        this.updatedChannel(channel);
    }

    @Override
    public String getWalletExtensionID() {
        return EXTENSION_ID;
    }

    @Override
    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeWalletExtension() {
        this.lock.lock();
        try {
            NetworkParameters params = this.getNetworkParameters();
            boolean hasMaxMoney = params != null ? params.hasMaxMoney() : true;
            Coin networkMaxMoney = params != null ? params.getMaxMoney() : NetworkParameters.MAX_MONEY;
            ClientState.StoredClientPaymentChannels.Builder builder = ClientState.StoredClientPaymentChannels.newBuilder();
            for (StoredClientChannel channel : this.mapChannels.values()) {
                Preconditions.checkState((channel.valueToMe.signum() >= 0 && (!hasMaxMoney || channel.valueToMe.compareTo(networkMaxMoney) <= 0) ? 1 : 0) != 0);
                Preconditions.checkState((channel.refundFees.signum() >= 0 && (!hasMaxMoney || channel.refundFees.compareTo(networkMaxMoney) <= 0) ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPubKey());
                Preconditions.checkState((channel.refund.getConfidence().getSource() == TransactionConfidence.Source.SELF ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPubKey());
                ClientState.StoredClientPaymentChannel.Builder value = ClientState.StoredClientPaymentChannel.newBuilder().setMajorVersion(channel.majorVersion).setId(ByteString.copyFrom((byte[])channel.id.getBytes())).setContractTransaction(ByteString.copyFrom((byte[])channel.contract.unsafeBitcoinSerialize())).setRefundFees(channel.refundFees.value).setRefundTransaction(ByteString.copyFrom((byte[])channel.refund.unsafeBitcoinSerialize())).setMyKey(ByteString.copyFrom((byte[])new byte[0])).setMyPublicKey(ByteString.copyFrom((byte[])channel.myKey.getPubKey())).setServerKey(ByteString.copyFrom((byte[])channel.serverKey.getPubKey())).setValueToMe(channel.valueToMe.value).setExpiryTime(channel.expiryTime);
                if (channel.close != null) {
                    value.setCloseTransactionHash(ByteString.copyFrom((byte[])channel.close.getHash().getBytes()));
                }
                builder.addChannels(value);
            }
            Object object = builder.build().toByteArray();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeWalletExtension(Wallet containingWallet, byte[] data) throws Exception {
        this.lock.lock();
        try {
            Preconditions.checkState((this.containingWallet == null || this.containingWallet == containingWallet ? 1 : 0) != 0);
            this.containingWallet = containingWallet;
            NetworkParameters params = containingWallet.getParams();
            ClientState.StoredClientPaymentChannels states = ClientState.StoredClientPaymentChannels.parseFrom(data);
            for (ClientState.StoredClientPaymentChannel storedState : states.getChannelsList()) {
                Transaction refundTransaction = params.getDefaultSerializer().makeTransaction(storedState.getRefundTransaction().toByteArray());
                refundTransaction.getConfidence().setSource(TransactionConfidence.Source.SELF);
                ECKey myKey = storedState.getMyKey().isEmpty() ? containingWallet.findKeyFromPubKey(storedState.getMyPublicKey().toByteArray()) : ECKey.fromPrivate(storedState.getMyKey().toByteArray());
                ECKey serverKey = storedState.hasServerKey() ? ECKey.fromPublicOnly(storedState.getServerKey().toByteArray()) : null;
                StoredClientChannel channel = new StoredClientChannel(storedState.getMajorVersion(), Sha256Hash.wrap(storedState.getId().toByteArray()), params.getDefaultSerializer().makeTransaction(storedState.getContractTransaction().toByteArray()), refundTransaction, myKey, serverKey, Coin.valueOf(storedState.getValueToMe()), Coin.valueOf(storedState.getRefundFees()), storedState.getExpiryTime(), false);
                if (storedState.hasCloseTransactionHash()) {
                    Sha256Hash closeTxHash = Sha256Hash.wrap(storedState.getCloseTransactionHash().toByteArray());
                    channel.close = containingWallet.getTransaction(closeTxHash);
                }
                this.putChannel(channel, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder buf = new StringBuilder("Client payment channel states:\n");
            for (StoredClientChannel channel : this.mapChannels.values()) {
                buf.append("  ").append(channel).append("\n");
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    private NetworkParameters getNetworkParameters() {
        return this.containingWallet != null ? this.containingWallet.getNetworkParameters() : null;
    }
}

