/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.protocols.channels.StateMachine;
import org.bitcoinj.protocols.channels.StoredClientChannel;
import org.bitcoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.script.Script;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;

public abstract class PaymentChannelClientState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelClientState.class);
    protected Coin valueToMe;
    protected final StateMachine<State> stateMachine = new StateMachine<State>(State.UNINITIALISED, this.getStateTransitions());
    final Wallet wallet;
    final ECKey myKey;
    final ECKey serverKey;
    protected StoredClientChannel storedChannel;

    PaymentChannelClientState(StoredClientChannel storedClientChannel, Wallet wallet) throws VerificationException {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.myKey = (ECKey)Preconditions.checkNotNull((Object)storedClientChannel.myKey);
        this.serverKey = (ECKey)Preconditions.checkNotNull((Object)storedClientChannel.serverKey);
        this.storedChannel = storedClientChannel;
        this.valueToMe = (Coin)Preconditions.checkNotNull((Object)storedClientChannel.valueToMe);
    }

    public synchronized boolean isSettlementTransaction(Transaction tx) {
        try {
            tx.verify();
            tx.getInput(0L).verify(this.getContractInternal().getOutput(0L));
            return true;
        }
        catch (VerificationException e) {
            return false;
        }
    }

    public PaymentChannelClientState(Wallet wallet, ECKey myKey, ECKey serverKey, Coin value, long expiryTimeInSeconds) throws VerificationException {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.serverKey = (ECKey)Preconditions.checkNotNull((Object)serverKey);
        this.myKey = (ECKey)Preconditions.checkNotNull((Object)myKey);
        this.valueToMe = (Coin)Preconditions.checkNotNull((Object)value);
    }

    protected synchronized void initWalletListeners() {
        if (this.storedChannel != null && this.storedChannel.close != null) {
            this.watchCloseConfirmations();
        }
        this.wallet.addCoinsReceivedEventListener(Threading.SAME_THREAD, new WalletCoinsReceivedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoinsReceived(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
                PaymentChannelClientState paymentChannelClientState = PaymentChannelClientState.this;
                synchronized (paymentChannelClientState) {
                    if (PaymentChannelClientState.this.getContractInternal() == null) {
                        return;
                    }
                    if (PaymentChannelClientState.this.isSettlementTransaction(tx)) {
                        log.info("Close: transaction {} closed contract {}", (Object)tx.getHash(), (Object)PaymentChannelClientState.this.getContractInternal().getHash());
                        PaymentChannelClientState.this.stateMachine.transition(State.CLOSED);
                        if (PaymentChannelClientState.this.storedChannel == null) {
                            return;
                        }
                        PaymentChannelClientState.this.storedChannel.close = tx;
                        PaymentChannelClientState.this.updateChannelInWallet();
                        PaymentChannelClientState.this.watchCloseConfirmations();
                    }
                }
            }
        });
    }

    protected void watchCloseConfirmations() {
        TransactionConfidence confidence = this.storedChannel.close.getConfidence();
        int numConfirms = Context.get().getEventHorizon();
        ListenableFuture<TransactionConfidence> future = confidence.getDepthFuture(numConfirms, Threading.SAME_THREAD);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<TransactionConfidence>(){

            public void onSuccess(TransactionConfidence result) {
                PaymentChannelClientState.this.deleteChannelFromWallet();
            }

            public void onFailure(Throwable t) {
                Throwables.propagate((Throwable)t);
            }
        });
    }

    private synchronized void deleteChannelFromWallet() {
        log.info("Close tx has confirmed, deleting channel from wallet: {}", (Object)this.storedChannel);
        StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
        channels.removeChannel(this.storedChannel);
        this.storedChannel = null;
    }

    public synchronized State getState() {
        return this.stateMachine.getState();
    }

    protected abstract Multimap<State, State> getStateTransitions();

    public abstract int getMajorVersion();

    public void initiate() throws ValueOutOfRangeException, InsufficientMoneyException {
        this.initiate(null);
    }

    public abstract void initiate(@Nullable KeyParameter var1) throws ValueOutOfRangeException, InsufficientMoneyException;

    protected void editContractSendRequest(SendRequest req) {
    }

    public abstract Transaction getContract();

    private synchronized Transaction makeUnsignedChannelContract(Coin valueToMe) throws ValueOutOfRangeException {
        Transaction tx = new Transaction(this.wallet.getParams());
        tx.addInput(this.getContractInternal().getOutput(0L));
        tx.addOutput(valueToMe, this.myKey.toAddress(this.wallet.getParams()));
        return tx;
    }

    public synchronized void checkNotExpired() {
        if (Utils.currentTimeSeconds() > this.getExpiryTime()) {
            this.stateMachine.transition(State.EXPIRED);
            this.disconnectFromChannel();
            throw new IllegalStateException("Channel expired");
        }
    }

    public synchronized IncrementedPayment incrementPaymentBy(Coin size, @Nullable KeyParameter userKey) throws ValueOutOfRangeException {
        this.stateMachine.checkState(State.READY);
        this.checkNotExpired();
        Preconditions.checkNotNull((Object)size);
        if (size.signum() < 0) {
            throw new ValueOutOfRangeException("Tried to decrement payment");
        }
        Coin newValueToMe = this.getValueToMe().subtract(size);
        if (newValueToMe.compareTo(Transaction.MIN_NONDUST_OUTPUT) < 0 && newValueToMe.signum() > 0) {
            log.info("New value being sent back as change was smaller than minimum nondust output, sending all");
            size = this.getValueToMe();
            newValueToMe = Coin.ZERO;
        }
        if (newValueToMe.signum() < 0) {
            throw new ValueOutOfRangeException("Channel has too little money to pay " + size + " satoshis");
        }
        Transaction tx = this.makeUnsignedChannelContract(newValueToMe);
        log.info("Signing new payment tx {}", (Object)tx);
        Transaction.SigHash mode = newValueToMe.equals(Coin.ZERO) ? Transaction.SigHash.NONE : Transaction.SigHash.SINGLE;
        TransactionSignature sig = tx.calculateSignature(0, this.myKey.maybeDecrypt(userKey), this.getSignedScript(), mode, true);
        this.valueToMe = newValueToMe;
        this.updateChannelInWallet();
        IncrementedPayment payment = new IncrementedPayment();
        payment.signature = sig;
        payment.amount = size;
        return payment;
    }

    protected synchronized void updateChannelInWallet() {
        if (this.storedChannel == null) {
            return;
        }
        this.storedChannel.valueToMe = this.getValueToMe();
        StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
        channels.updatedChannel(this.storedChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectFromChannel() {
        if (this.storedChannel == null) {
            return;
        }
        StoredClientChannel storedClientChannel = this.storedChannel;
        synchronized (storedClientChannel) {
            this.storedChannel.active = false;
        }
    }

    @VisibleForTesting
    synchronized void fakeSave() {
        try {
            this.wallet.commitTx(this.getContractInternal());
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        this.stateMachine.transition(State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER);
    }

    @VisibleForTesting
    abstract void doStoreChannelInWallet(Sha256Hash var1);

    public synchronized void storeChannelInWallet(Sha256Hash id) {
        this.stateMachine.checkState(State.SAVE_STATE_IN_WALLET);
        Preconditions.checkState((id != null ? 1 : 0) != 0);
        if (this.storedChannel != null) {
            Preconditions.checkState((boolean)this.storedChannel.id.equals(id));
            return;
        }
        this.doStoreChannelInWallet(id);
        try {
            this.wallet.commitTx(this.getContractInternal());
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        this.stateMachine.transition(State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER);
    }

    public abstract Coin getRefundTxFees();

    @VisibleForTesting
    abstract Transaction getRefundTransaction();

    public abstract Coin getTotalValue();

    public synchronized Coin getValueRefunded() {
        this.stateMachine.checkState(State.READY);
        return this.valueToMe;
    }

    public synchronized Coin getValueSpent() {
        return this.getTotalValue().subtract(this.getValueRefunded());
    }

    protected abstract Coin getValueToMe();

    protected abstract long getExpiryTime();

    protected abstract Transaction getContractInternal();

    protected abstract Script getContractScript();

    protected abstract Script getSignedScript();

    public static class IncrementedPayment {
        public TransactionSignature signature;
        public Coin amount;
    }

    public static enum State {
        UNINITIALISED,
        NEW,
        INITIATED,
        WAITING_FOR_SIGNED_REFUND,
        SAVE_STATE_IN_WALLET,
        PROVIDE_MULTISIG_CONTRACT_TO_SERVER,
        READY,
        EXPIRED,
        CLOSED;

    }
}

