/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.bitbucket.johness.javacef.CefHelper;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private HashSet<CefClient> clients_ = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition cefInitialized = this.lock.newCondition();
    private final Condition cefShutdown = this.lock.newCondition();
    private CefSettings settings_ = null;
    private boolean executeDefaultShutdown_ = false;
    private final Thread context = new Thread("JCEF-MessageQueue"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            if (!this.isAlive() && super.getState() == Thread.State.NEW) {
                CefApp.this.lock.lock();
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        CefApp.this.initialize();
                    }
                    super.start();
                    CefApp.this.cefInitialized.awaitUninterruptibly();
                }
                finally {
                    CefApp.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CefApp.this.lock.lock();
            try {
                if (CefApp.getState().compareTo(CefAppState.INITIALIZED) < 0) {
                    CefApp.this.initialize();
                }
                CefApp.this.cefInitialized.signal();
                if (OS.isMacintosh() || OS.isWindows()) {
                    CefApp.this.cefShutdown.awaitUninterruptibly();
                } else {
                    boolean doLoop = true;
                    while (doLoop) {
                        CefApp.this.doMessageLoopWork();
                        try {
                            doLoop = !CefApp.this.cefShutdown.await(33L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                CefApp.this.lock.unlock();
            }
        }
    };

    private CefApp(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        super(args);
        try {
            CefHelper.extractNativeAndResource();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        if (OS.isWindows()) {
            System.loadLibrary("jawt");
            System.loadLibrary("libcef");
        } else if (OS.isLinux()) {
            System.loadLibrary("cef");
        }
        System.loadLibrary("jcef");
        if (appHandler_ == null) {
            appHandler_ = this;
        }
        if (!this.N_PreInitialize()) {
            throw new IllegalStateException("Failed to pre-initialize native code");
        }
        if (OS.isMacintosh()) {
            Runtime.getRuntime().addShutdownHook(new Thread("JCEF Shutdown Hook"){

                @Override
                public void run() {
                    try {
                        if (CefApp.this.executeDefaultShutdown_) {
                            return;
                        }
                        for (CefClient c : CefApp.this.clients_) {
                            c.dispose();
                        }
                        Thread.sleep(150L);
                        CefApp.this.lock.lock();
                        CefApp.this.cefShutdown.signal();
                        CefApp.this.lock.unlock();
                        CefApp.this.N_Shutdown();
                        Thread.sleep(150L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) throws UnsatisfiedLinkError {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        if (settings != null && CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            self = new CefApp(args, settings);
            CefApp.setState(CefAppState.NEW);
        }
        return self;
    }

    public final void setSettings(CefSettings settings) throws IllegalStateException {
        if (CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CefAppState getState() {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            return state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setState(final CefAppState state) {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            state_ = state;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (appHandler_ != null) {
                    appHandler_.stateHasChanged(state);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (!this.clients_.isEmpty()) {
                    for (CefClient c : this.clients_) {
                        c.dispose();
                    }
                }
                this.shutdown();
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.INITIALIZING);
                this.context.setDaemon(true);
                this.context.start();
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefClient client = new CefClient();
                this.clients_.add(client);
                return client;
            }
        }
        throw new IllegalStateException("Can't crate client in state " + (Object)((Object)state_));
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    protected final void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.shutdown();
        }
    }

    protected final void handleBeforeTerminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler = (CefAppHandler)(appHandler_ == null ? this : appHandler_);
                if (!handler.onBeforeTerminate()) {
                    CefApp.this.executeDefaultShutdown_ = true;
                    CefApp.this.dispose();
                }
            }
        });
    }

    private final void initialize() {
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    CefSettings settings;
                    String library_path = CefApp.this.getJcefLibPath();
                    System.out.println("initialize on " + Thread.currentThread() + " with library path " + library_path);
                    CefSettings cefSettings = settings = CefApp.this.settings_ != null ? CefApp.this.settings_ : new CefSettings();
                    if (OS.isMacintosh()) {
                        if (settings.browser_subprocess_path == null) {
                            Path path = Paths.get(library_path, "../Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
                            settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isWindows()) {
                        if (settings.browser_subprocess_path == null) {
                            settings.browser_subprocess_path = library_path + "\\jcef_helper.exe";
                        }
                    } else if (OS.isLinux()) {
                        if (settings.browser_subprocess_path == null) {
                            settings.browser_subprocess_path = library_path + "/jcef_helper";
                        }
                        if (settings.resources_dir_path == null) {
                            settings.resources_dir_path = library_path;
                        }
                        if (settings.locales_dir_path == null) {
                            settings.locales_dir_path = library_path + "/locales";
                        }
                    }
                    if (CefApp.this.N_Initialize(library_path, appHandler_, settings)) {
                        CefApp.setState(CefAppState.INITIALIZED);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void shutdown() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    System.out.println("  shutdown on " + Thread.currentThread());
                    try {
                        CefApp.this.lock.lock();
                        CefApp.this.cefShutdown.signal();
                    }
                    finally {
                        CefApp.this.lock.unlock();
                    }
                    try {
                        CefApp.this.context.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CefApp.this.N_Shutdown();
                    System.out.println("shutdown complete");
                    if (CefApp.this.executeDefaultShutdown_) {
                        CefApp.this.continueTerminate();
                    }
                    CefApp.setState(CefAppState.TERMINATED);
                    self = null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void continueTerminate() {
        new Thread("JCEF Terminate"){

            @Override
            public void run() {
                CefApp.this.N_ContinueDefaultTerminate();
            }
        }.start();
    }

    private final void doMessageLoopWork() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CefApp.getState() != CefAppState.TERMINATED) {
                        CefApp.this.N_DoMessageLoopWork();
                    }
                }
            });
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private final String getJcefLibPath() {
        String[] paths;
        String library_path = System.getProperty("java.library.path");
        for (String path : paths = library_path.split(System.getProperty("path.separator"))) {
            File dir = new File(path);
            String[] found = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("libjcef.dylib") || name.equalsIgnoreCase("libjcef.so") || name.equalsIgnoreCase("jcef.dll");
                }
            });
            if (found == null || found.length == 0) continue;
            return path;
        }
        return library_path;
    }

    private final native boolean N_PreInitialize();

    private final native boolean N_Initialize(String var1, CefAppHandler var2, CefSettings var3);

    private final native void N_Shutdown();

    private final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    private final native void N_ContinueDefaultTerminate();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public final class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(int jcefCommitNo, int cefMajor, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CHROME_VERSION_BUILD + "." + this.JCEF_COMMIT_NUMBER;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CHROME_VERSION_BUILD + "." + this.CEF_COMMIT_NUMBER;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\n" + "CEF Version = " + this.getCefVersion() + "\n" + "Chromium Version = " + this.getChromeVersion();
        }
    }
}

