/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice.util;

import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractUnoChoiceParameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;

public class Utils {
    private Utils() {
    }

    @Nonnull
    public static Set<Script> getAllScriptlerScripts() {
        Set scripts = ScriptlerConfiguration.getConfiguration().getScripts();
        return scripts;
    }

    public static boolean isSelected(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        String text = obj.toString();
        return StringUtils.isNotBlank((String)text) && text.endsWith(":selected");
    }

    @Nonnull
    public static String escapeSelected(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (StringUtils.isBlank((String)text)) {
            return "";
        }
        if (Utils.isSelected(text)) {
            return text.substring(0, text.indexOf(":selected"));
        }
        return text;
    }

    @Nonnull
    public static String createRandomParameterName(@Nullable String prefix, @Nullable String suffix) {
        String paramName = "";
        if (StringUtils.isNotBlank((String)prefix)) {
            paramName = prefix + "-";
        }
        paramName = paramName + System.nanoTime();
        if (StringUtils.isNotBlank((String)suffix)) {
            paramName = paramName + "-" + suffix;
        }
        return paramName;
    }

    @Nonnull
    public static Map<String, String> getSystemEnv() {
        return System.getenv();
    }

    @CheckForNull
    public static Project<?, ?> getProjectByName(@Nonnull String projectName) {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            List projects = instance.getAllItems(Project.class);
            for (Project p : projects) {
                if (!p.getName().equals(projectName)) continue;
                return p;
            }
        }
        return null;
    }

    @CheckForNull
    public static Project findProjectByParameterUUID(@Nonnull String parameterUUID) {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            List projects = instance.getAllItems(Project.class);
            for (Project project : projects) {
                if (!Utils.isParameterDefintionOf(parameterUUID, project)) continue;
                return project;
            }
        }
        return null;
    }

    private static boolean isParameterDefintionOf(@Nonnull String parameterUUID, @Nonnull Project project) {
        List<ParameterDefinition> parameterDefinitions = Utils.getProjectParameterDefinitions(project);
        for (ParameterDefinition pd : parameterDefinitions) {
            AbstractUnoChoiceParameter parameterDefinition;
            String uuid;
            if (!(pd instanceof AbstractUnoChoiceParameter) || !ObjectUtils.equals((Object)parameterUUID, (Object)(uuid = (parameterDefinition = (AbstractUnoChoiceParameter)pd).getRandomName()))) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static List<ParameterDefinition> getProjectParameterDefinitions(@Nonnull Project project) {
        List parameterDefinitions;
        ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (parametersDefinitionProperty != null && (parameterDefinitions = parametersDefinitionProperty.getParameterDefinitions()) != null) {
            return parameterDefinitions;
        }
        return Collections.EMPTY_LIST;
    }

    @Nonnull
    public static Map<String, Object> getGlobalNodeProperties() {
        DescribableList globalNodeProperties;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Jenkins instance = Jenkins.getInstance();
        if (instance != null && (globalNodeProperties = instance.getGlobalNodeProperties()) != null) {
            for (NodeProperty nodeProperty : globalNodeProperties) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                EnvironmentVariablesNodeProperty envNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                map.putAll((Map<String, Object>)envNodeProperty.getEnvVars());
            }
        }
        return map;
    }
}

