/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice.model;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.biouno.unochoice.model.AbstractScript;
import org.biouno.unochoice.model.GroovyScript;
import org.biouno.unochoice.model.ScriptDescriptor;
import org.biouno.unochoice.model.ScriptlerScriptParameter;
import org.biouno.unochoice.util.Utils;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ScriptlerScript
extends AbstractScript {
    private static final long serialVersionUID = -6600327523009436354L;
    private final String scriptlerScriptId;
    private final Map<String, String> parameters;

    @DataBoundConstructor
    public ScriptlerScript(String scriptlerScriptId, List<ScriptlerScriptParameter> parameters) {
        this.scriptlerScriptId = scriptlerScriptId;
        this.parameters = new LinkedHashMap<String, String>();
        if (parameters != null) {
            for (ScriptlerScriptParameter parameter : parameters) {
                this.parameters.put(parameter.getName(), parameter.getValue());
            }
        }
    }

    public String getScriptlerScriptId() {
        return this.scriptlerScriptId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Object eval() {
        return this.eval(null);
    }

    @Override
    public Object eval(Map<String, String> parameters) {
        Map<String, String> envVars = Utils.getSystemEnv();
        LinkedHashMap<String, String> evaledParameters = new LinkedHashMap<String, String>(envVars);
        if (parameters != null && !parameters.isEmpty()) {
            evaledParameters.putAll(parameters);
            for (String key : this.getParameters().keySet()) {
                String value = this.getParameters().get(key);
                value = Util.replaceMacro((String)value, parameters);
                evaledParameters.put(key, value);
            }
        } else {
            evaledParameters.putAll(this.getParameters());
        }
        return this.toGroovyScript().eval(evaledParameters);
    }

    public GroovyScript toGroovyScript() {
        Script scriptler = ScriptHelper.getScript((String)this.getScriptlerScriptId(), (boolean)true);
        return new GroovyScript(new SecureGroovyScript(scriptler.script, false, null), null);
    }

    @Extension
    public static class DescriptorImpl
    extends ScriptDescriptor {
        public String getDisplayName() {
            return "Scriptler Script";
        }

        public AbstractScript newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            ScriptlerScript script = null;
            String scriptScriptId = jsonObject.getString("scriptlerScriptId");
            if (scriptScriptId != null && !scriptScriptId.trim().equals("")) {
                ArrayList<ScriptlerScriptParameter> parameters = new ArrayList<ScriptlerScriptParameter>();
                JSONObject defineParams = jsonObject.getJSONObject("defineParams");
                if (defineParams != null && !defineParams.isNullObject()) {
                    JSONObject argsObj = defineParams.optJSONObject("parameters");
                    if (argsObj == null) {
                        JSONArray argsArrayObj = defineParams.optJSONArray("parameters");
                        if (argsArrayObj != null) {
                            for (int i = 0; i < argsArrayObj.size(); ++i) {
                                JSONObject obj = argsArrayObj.getJSONObject(i);
                                String name = obj.getString("name");
                                String value = obj.getString("value");
                                if (name == null || name.trim().equals("") || value == null) continue;
                                ScriptlerScriptParameter param = new ScriptlerScriptParameter(name, value);
                                parameters.add(param);
                            }
                        }
                    } else {
                        String name = argsObj.getString("name");
                        String value = argsObj.getString("value");
                        if (name != null && !name.trim().equals("") && value != null) {
                            ScriptlerScriptParameter param = new ScriptlerScriptParameter(name, value);
                            parameters.add(param);
                        }
                    }
                }
                script = new ScriptlerScript(scriptScriptId, parameters);
            }
            return script;
        }
    }
}

