/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice;

import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.ParameterValue;
import hudson.model.Project;
import hudson.model.StringParameterValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractUnoChoiceParameter;
import org.biouno.unochoice.ScriptableParameter;
import org.biouno.unochoice.model.Script;
import org.biouno.unochoice.util.ScriptCallback;
import org.biouno.unochoice.util.Utils;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractScriptableParameter
extends AbstractUnoChoiceParameter
implements ScriptableParameter<Map<Object, Object>> {
    private static final long serialVersionUID = 1322134413144485771L;
    protected static final String SEPARATOR = "__LESEP__";
    protected static final String EQUALS = "=";
    protected static final String JENKINS_PROJECT_VARIABLE_NAME = "jenkinsProject";
    protected static final String JENKINS_BUILD_VARIABLE_NAME = "jenkinsBuild";
    private volatile int visibleItemCount = 1;
    protected final Script script;
    private final String projectName;

    protected AbstractScriptableParameter(String name, String description, Script script) {
        super(name, description);
        this.script = script;
        this.projectName = null;
    }

    protected AbstractScriptableParameter(String name, String description, String randomName, Script script) {
        super(name, description, randomName);
        Object o;
        Ancestor ancestor;
        this.script = script;
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        String projectName = null;
        if (currentRequest != null && (ancestor = currentRequest.findAncestor(AbstractItem.class)) != null && (o = ancestor.getObject()) instanceof AbstractItem) {
            AbstractItem parentItem = (AbstractItem)o;
            projectName = parentItem.getName();
        }
        this.projectName = projectName;
    }

    public Script getScript() {
        return this.script;
    }

    public Map<Object, Object> getParameters() {
        return Collections.emptyMap();
    }

    private Map<Object, Object> getHelperParameters() {
        LinkedHashMap<Object, Object> helperParameters = new LinkedHashMap<Object, Object>();
        Project project = null;
        project = StringUtils.isNotBlank((String)this.projectName) ? Utils.getProjectByName(this.projectName) : Utils.findProjectByParameterUUID(this.getRandomName());
        if (project != null) {
            helperParameters.put(JENKINS_PROJECT_VARIABLE_NAME, project);
            AbstractBuild build = project.getLastBuild();
            if (build != null && build.getHasArtifacts()) {
                helperParameters.put(JENKINS_BUILD_VARIABLE_NAME, build);
            }
        }
        Map<String, Object> globalNodeProperties = Utils.getGlobalNodeProperties();
        helperParameters.putAll(globalNodeProperties);
        return helperParameters;
    }

    public Map<Object, Object> getChoices() {
        Object choices = this.getChoices((Map)this.getParameters());
        this.visibleItemCount = choices.size();
        return choices;
    }

    @Override
    public Map<Object, Object> getChoices(Map<Object, Object> parameters) {
        Object value = this.eval(parameters);
        if (value instanceof Map) {
            Map map = (Map)value;
            this.visibleItemCount = map.size();
            return map;
        }
        if (value instanceof List) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (Object o : (List)value) {
                map.put(o, o);
            }
            this.visibleItemCount = map.size();
            return map;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Script parameter with name '%s' is not an instance of java.util.Map. The parameter value is %s", this.getName(), value));
        }
        return Collections.emptyMap();
    }

    public String getChoicesAsString() {
        return this.getChoicesAsString(this.getParameters());
    }

    public String getChoicesAsString(Map<Object, Object> parameters) {
        Object value = this.eval(parameters);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private Object eval(Map<Object, Object> parameters) {
        try {
            Map<Object, Object> scriptParameters = this.getHelperParameters();
            scriptParameters.putAll(parameters);
            ScriptCallback callback = new ScriptCallback(this.getName(), this.script, scriptParameters);
            return callback.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error executing script for dynamic parameter", e);
            return Collections.emptyMap();
        }
    }

    public ParameterValue getDefaultParameterValue() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "getDefaultParameterValue");
        }
        String firstElement = "";
        Object choices = this.getChoices(Collections.emptyMap());
        if (choices != null && !choices.isEmpty()) {
            firstElement = choices.entrySet().iterator().next().getValue();
        }
        String name = this.getName();
        String value = ObjectUtils.toString((Object)firstElement, (String)"");
        StringParameterValue stringParameterValue = new StringParameterValue(name, value);
        return stringParameterValue;
    }

    public int getVisibleItemCount() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "getVisibleItemCount");
        }
        if (this.visibleItemCount <= 0) {
            this.visibleItemCount = 1;
        }
        if (this.visibleItemCount < 10) {
            return this.visibleItemCount;
        }
        return 10;
    }
}

