/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractScriptableParameter;
import org.biouno.unochoice.CascadableParameter;
import org.biouno.unochoice.model.Script;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class AbstractCascadableParameter
extends AbstractScriptableParameter
implements CascadableParameter<Map<Object, Object>> {
    private static final long serialVersionUID = 3795727126307053346L;
    protected final Map<Object, Object> parameters = new LinkedHashMap<Object, Object>();
    private final String referencedParameters;

    protected AbstractCascadableParameter(String name, String description, Script script, String referencedParameters) {
        super(name, description, script);
        this.referencedParameters = referencedParameters;
    }

    protected AbstractCascadableParameter(String name, String description, String randomName, Script script, String referencedParameters) {
        super(name, description, randomName, script);
        this.referencedParameters = referencedParameters;
    }

    @Override
    public String getReferencedParameters() {
        return this.referencedParameters;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @JavaScriptMethod
    public void doUpdate(String parameters) {
        String[] params;
        this.getParameters().clear();
        for (String param : params = parameters.split("__LESEP__")) {
            String name;
            String[] nameValue = param.split("=");
            if (nameValue.length == 1) {
                name = nameValue[0].trim();
                if (name.length() <= 0) continue;
                this.getParameters().put(name, "");
                continue;
            }
            if (nameValue.length == 2) {
                name = nameValue[0];
                String value = nameValue[1];
                this.getParameters().put(name, value);
                continue;
            }
            if (nameValue.length <= 2) continue;
            name = nameValue[0];
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < nameValue.length; ++i) {
                sb.append(nameValue[i]);
                if (i + 1 >= nameValue.length) continue;
                sb.append("=");
            }
            String value = sb.toString();
            this.getParameters().put(name, value);
        }
    }

    @Override
    @JavaScriptMethod
    public List<Object> getChoicesForUI() {
        Object mapResult = this.getChoices((Map)this.getParameters());
        return Arrays.asList(mapResult.values(), mapResult.keySet());
    }

    public String[] getReferencedParametersAsArray() {
        String referencedParameters = this.getReferencedParameters();
        if (StringUtils.isNotBlank((String)referencedParameters)) {
            String[] array = referencedParameters.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String value : array) {
                if (!StringUtils.isNotBlank((String)(value = value.trim()))) continue;
                list.add(value);
            }
            return list.toArray(new String[0]);
        }
        return new String[0];
    }
}

