/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class JavaVersion
implements GroovyObject {
    private static final Logger LOGGER;
    private static final String sourceCode = "\nimport java.lang.reflect.Method;\n\npublic class JavaVersion {\n    public static void main(String[] args) {\n        System.out.print(getVersion());\n    }\n\n    public static int getVersion() {\n        try {\n            Method mVersion = Runtime.class.getMethod(\"version\");\n            Object version = mVersion.invoke(null);\n            try {\n                Method mFeature = version.getClass().getMethod(\"feature\");\n                return (int)mFeature.invoke(version);\n            } catch (Exception e) {\n                Method mMajor = version.getClass().getMethod(\"major\");\n                return (int)mMajor.invoke(version);\n            }\n        } catch (Exception e) {\n            try {\n                String prop = System.getProperty(\"java.specification.version\");\n                int pos = prop.lastIndexOf('.');\n                return Integer.parseInt(prop.substring(pos + 1));\n            } catch (Exception e1) {\n                return 8;\n            }\n        }\n    }\n}\n";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JavaVersion() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static int get(String javaHome) {
        Path path = Files.createTempDirectory("badass-", new FileAttribute[0]);
        File javaFile = path.resolve("JavaVersion.java").toFile();
        ResourceGroovyMethods.leftShift((File)javaFile, (Object)sourceCode);
        GStringImpl javacCmd = new GStringImpl(new Object[]{javaHome}, new String[]{"", "/bin/javac -cp . -d . JavaVersion.java"});
        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javacCmd}, new String[]{"Executing: ", ""})));
        Process javacProc = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)javacCmd), (String[])((String[])ScriptBytecodeAdapter.asType(null, String[].class)), (File)path.toFile());
        StringBuilder javacErrOutput = new StringBuilder();
        ProcessGroovyMethods.consumeProcessErrorStream((Process)javacProc, (Appendable)javacErrOutput);
        if (!javacProc.waitFor(30, TimeUnit.SECONDS)) {
            throw (Throwable)new GradleException("javac JavaVersion.java hasn't exited after 30 seconds.");
        }
        String javacOutput = ProcessGroovyMethods.getText((Process)javacProc);
        LOGGER.info(javacOutput);
        if (javacProc.exitValue() != 0) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javacErrOutput}, new String[]{"javac JavaVersion.java failed: ", ""})));
        }
        if (StringGroovyMethods.size((CharSequence)javacErrOutput) > 0) {
            LOGGER.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javacErrOutput}, new String[]{"javac failed: ", ""})));
        }
        GStringImpl javaCmd = new GStringImpl(new Object[]{javaHome}, new String[]{"", "/bin/java -cp . JavaVersion"});
        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaCmd}, new String[]{"Executing: ", ""})));
        Process javaProc = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)javaCmd), (String[])((String[])ScriptBytecodeAdapter.asType(null, String[].class)), (File)path.toFile());
        StringBuilder javaErrOutput = new StringBuilder();
        ProcessGroovyMethods.consumeProcessErrorStream((Process)javaProc, (Appendable)javaErrOutput);
        if (!javaProc.waitFor(30, TimeUnit.SECONDS)) {
            throw (Throwable)new GradleException("java JavaVersion hasn't exited after 30 seconds.");
        }
        String javaOutput = ProcessGroovyMethods.getText((Process)javaProc);
        LOGGER.info(javaOutput);
        if (javaProc.exitValue() != 0) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaErrOutput}, new String[]{"java JavaVersion failed: ", ""})));
        }
        if (StringGroovyMethods.size((CharSequence)javaErrOutput) > 0) {
            LOGGER.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaErrOutput}, new String[]{"java failed: ", ""})));
        }
        int n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)javaOutput, Integer.TYPE));
        try {
            return n;
        }
        catch (Exception e) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{javaOutput}, new String[]{"Cannot parse java version: ", ""})));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JavaVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOGGER = logger = Logging.getLogger(JavaVersion.class);
    }

    public static String getSourceCode() {
        return sourceCode;
    }
}

