/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.relationship.MemberNameResolver;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollectorImpl;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.MiscConstants;
import org.benf.cfr.reader.util.MiscUtils;
import org.benf.cfr.reader.util.collections.Functional;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.functors.Predicate;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.DumperFactory;
import org.benf.cfr.reader.util.output.ExceptionDumper;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.NopSummaryDumper;
import org.benf.cfr.reader.util.output.ProgressDumper;
import org.benf.cfr.reader.util.output.SummaryDumper;
import org.benf.cfr.reader.util.output.ToStringDumper;

public class Driver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doClass(DCCommonState dcCommonState, String path, boolean skipInnerClass, DumperFactory dumperFactory) {
        Options options = dcCommonState.getOptions();
        IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(options);
        Dumper d = new ToStringDumper();
        ExceptionDumper ed = dumperFactory.getExceptionDumper();
        try {
            NopSummaryDumper summaryDumper = new NopSummaryDumper();
            ClassFile c = dcCommonState.getClassFileMaybePath(path);
            if (skipInnerClass && c.isInnerClass()) {
                return;
            }
            dcCommonState.configureWith(c);
            dumperFactory.getProgressDumper().analysingType(c.getClassType());
            try {
                c = dcCommonState.getClassFile(c.getClassType());
            }
            catch (CannotLoadClassException cannotLoadClassException) {
                // empty catch block
            }
            if (((Boolean)options.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                c.loadInnerClasses(dcCommonState);
            }
            if (((Boolean)options.getOption(OptionsImpl.RENAME_DUP_MEMBERS)).booleanValue()) {
                MemberNameResolver.resolveNames(dcCommonState, ListFactory.newList(dcCommonState.getClassCache().getLoadedTypes()));
            }
            c.analyseTop(dcCommonState);
            TypeUsageCollectorImpl collectingDumper = new TypeUsageCollectorImpl(c);
            c.collectTypeUsages(collectingDumper);
            d = dumperFactory.getNewTopLevelDumper(c.getClassType(), summaryDumper, collectingDumper.getTypeUsageInformation(), illegalIdentifierDump);
            String methname = (String)options.getOption(OptionsImpl.METHODNAME);
            if (methname == null) {
                c.dump(d);
            } else {
                try {
                    for (Method method : c.getMethodByName(methname)) {
                        method.dump(d, true);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("No such method '" + methname + "'.");
                }
            }
            d.print("");
        }
        catch (RuntimeException e) {
            ed.noteException(path, null, e);
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doJar(DCCommonState dcCommonState, String path, DumperFactory dumperFactory) {
        Options options = dcCommonState.getOptions();
        IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(options);
        SummaryDumper summaryDumper = null;
        try {
            final Predicate<String> matcher = MiscUtils.mkRegexFilter((String)options.getOption(OptionsImpl.JAR_FILTER), true);
            ProgressDumper progressDumper = dumperFactory.getProgressDumper();
            boolean silent = (Boolean)options.getOption(OptionsImpl.SILENT);
            summaryDumper = dumperFactory.getSummaryDumper();
            summaryDumper.notify("Summary for " + path);
            summaryDumper.notify("Decompiled with CFR " + MiscConstants.CFR_VERSION);
            progressDumper.analysingPath(path);
            List<JavaTypeInstance> types = dcCommonState.explicitlyLoadJar(path);
            types = Functional.filter(types, new Predicate<JavaTypeInstance>(){

                @Override
                public boolean test(JavaTypeInstance in) {
                    return matcher.test(in.getRawName());
                }
            });
            if (((Boolean)options.getOption(OptionsImpl.RENAME_DUP_MEMBERS)).booleanValue() || ((Boolean)options.getOption(OptionsImpl.RENAME_ENUM_MEMBERS)).booleanValue()) {
                MemberNameResolver.resolveNames(dcCommonState, types);
            }
            for (JavaTypeInstance type : types) {
                Dumper d = new ToStringDumper();
                try {
                    ClassFile c = dcCommonState.getClassFile(type);
                    if (c.isInnerClass()) {
                        d = null;
                        continue;
                    }
                    if (!silent) {
                        progressDumper.analysingType(type);
                    }
                    if (((Boolean)options.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                        c.loadInnerClasses(dcCommonState);
                    }
                    c.analyseTop(dcCommonState);
                    TypeUsageCollectorImpl collectingDumper = new TypeUsageCollectorImpl(c);
                    c.collectTypeUsages(collectingDumper);
                    d = dumperFactory.getNewTopLevelDumper(c.getClassType(), summaryDumper, collectingDumper.getTypeUsageInformation(), illegalIdentifierDump);
                    c.dump(d);
                    d.print("\n");
                    d.print("\n");
                }
                catch (Dumper.CannotCreate e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    d.print(e.toString()).print("\n").print("\n").print("\n");
                }
                finally {
                    if (d == null) continue;
                    d.close();
                }
            }
        }
        catch (RuntimeException e) {
            dumperFactory.getExceptionDumper().noteException(path, "Exception analysing jar", e);
            if (summaryDumper != null) {
                summaryDumper.notify("Exception analysing jar " + e);
            }
        }
        finally {
            if (summaryDumper != null) {
                summaryDumper.close();
            }
        }
    }
}

