/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling.hosts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.james.jdkim.api.JDKIM;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calsvc.scheduling.hosts.BwHost;
import org.bedework.calsvc.scheduling.hosts.BwHostsMBean;
import org.bedework.calsvc.scheduling.hosts.HostInfo;
import org.bedework.util.config.ConfigurationStore;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.misc.Util;

public class BwHosts
extends ConfBase
implements BwHostsMBean {
    private static final String confDirName = "hosts";
    private static List<HostInfo> hostInfos = new ArrayList<HostInfo>();
    private static List<BwHost> hostConfigs = new ArrayList<BwHost>();
    private static JDKIM jdkim;
    private static final String defaultJDKIMClass = "org.apache.james.jdkim.api.JDKIM";

    public BwHosts() {
        super("org.bedework.ischedule:service=Hosts", confDirName, "Hosts");
    }

    public String loadConfig() {
        return null;
    }

    @Override
    public String getHost(String hostname) {
        HostInfo host = this.get(hostname);
        if (host != null) {
            return host.toString();
        }
        return hostname + " not found";
    }

    @Override
    public String addIscheduleHost(String hostname, int port, boolean secure, String url, String principal, String pw) {
        String result;
        try {
            BwHost bh = this.find(hostname);
            if (bh == null) {
                HostInfo hi = new HostInfo();
                hi.setHostname(hostname);
                hi.setPort(port);
                hi.setSecure(secure);
                hi.setIScheduleUrl(url);
                hi.setISchedulePrincipal(principal);
                hi.setIScheduleCredentials(pw);
                hi.setSupportsISchedule(true);
                bh = new BwHost(this.getStore(), this.getServiceName(), hi);
                bh.saveConfig();
                this.register("hostconf", hostname, bh);
                hostConfigs.add(bh);
                return "added OK";
            }
            HostInfo hi = (HostInfo)bh.getConfig();
            if (hi.getSupportsISchedule()) {
                return "already supports ischedule";
            }
            hi.setPort(port);
            hi.setSecure(secure);
            hi.setIScheduleUrl(url);
            hi.setISchedulePrincipal(principal);
            hi.setIScheduleCredentials(pw);
            hi.setSupportsISchedule(true);
            bh.saveConfig();
            result = "updated OK";
        }
        catch (Throwable t) {
            result = t.getMessage();
            this.error(t);
        }
        return result;
    }

    @Override
    public List<String> listHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (Util.isEmpty(hostInfos)) {
            hosts.add("No hosts defined");
            return hosts;
        }
        for (HostInfo hi : hostInfos) {
            hosts.add(hi.getHostname());
        }
        return hosts;
    }

    @Override
    public String loadConfigs() {
        try {
            ConfigurationStore cfs = this.getStore();
            hostInfos = new ArrayList<HostInfo>();
            List hostNames = cfs.getConfigs();
            if (hostNames.isEmpty()) {
                return "No hosts";
            }
            hostConfigs = new ArrayList<BwHost>();
            for (String hn : hostNames) {
                HostInfo hi = this.getHostInfo(cfs, hn);
                if (hi == null) continue;
                hostInfos.add(hi);
                ObjectName objectName = this.createObjectName("hostconf", hn);
                BwHost bh = new BwHost(this.getStore(), objectName.toString(), hi);
                this.register("hostconf", hn, bh);
                hostConfigs.add(bh);
            }
            return "OK";
        }
        catch (Throwable t) {
            this.error("Failed to start management context");
            this.error(t);
            return "failed";
        }
    }

    public HostInfo get(String name) {
        return BwHosts.getHostInfo(name);
    }

    public BwHost find(String name) {
        for (BwHost bh : hostConfigs) {
            if (!((HostInfo)bh.getConfig()).getHostname().equals(name)) continue;
            return bh;
        }
        return null;
    }

    public void add(HostInfo val) {
    }

    public void update(HostInfo val) {
    }

    public void delete(HostInfo val) {
    }

    public static HostInfo getHostForRecipient(String val) {
        try {
            URI uri = new URI(val);
            String scheme = uri.getScheme();
            String domain = null;
            if (scheme == null || "mailto".equals(scheme.toLowerCase())) {
                if (val.indexOf("@") > 0) {
                    domain = val.substring(val.indexOf("@") + 1);
                }
            } else {
                domain = uri.getHost();
            }
            if (domain == null) {
                throw new BedeworkException("org.bedework.caladdr.bad");
            }
            return BwHosts.getHostInfo(domain);
        }
        catch (URISyntaxException use) {
            throw new BedeworkException("org.bedework.caladdr.bad");
        }
    }

    public static HostInfo getHostInfo(String name) {
        for (HostInfo hi : hostInfos) {
            if (!hi.getHostname().equals(name)) continue;
            return hi;
        }
        return null;
    }

    public static JDKIM getJDKIM() {
        if (jdkim == null) {
            jdkim = (JDKIM)BwHosts.loadInstance(Thread.currentThread().getContextClassLoader(), defaultJDKIMClass, JDKIM.class);
        }
        return jdkim;
    }

    public static void refreshStoredKeys() {
        for (BwHost bwh : hostConfigs) {
            HostInfo hi = (HostInfo)bwh.getConfig();
            List<String> keys = hi.getDkimPublicKeys();
            if (Util.isEmpty(keys)) continue;
            for (String s : keys) {
                String[] selKey = s.split("=");
                BwHosts.getJDKIM().addDKIMVerifierStoredKey(hi.getHostname(), selKey[0], selKey[1]);
            }
        }
    }

    private synchronized HostInfo getHostInfo(ConfigurationStore cfs, String configName) {
        try {
            return (HostInfo)cfs.getConfig(configName);
        }
        catch (Throwable t) {
            this.error(t);
            return null;
        }
    }

    private static Object loadInstance(ClassLoader loader, String cname, Class<?> interfaceClass) {
        try {
            Class<?> cl = loader.loadClass(cname);
            if (cl == null) {
                throw new BedeworkException("Class " + cname + " not found");
            }
            Object o = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!interfaceClass.isInstance(o)) {
                throw new BedeworkException("Class " + cname + " is not a subclass of " + interfaceClass.getName());
            }
            return o;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BedeworkException(t);
        }
    }
}

