/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import org.bedework.base.exc.BedeworkBadRequest;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.SchedulingOwner;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.AttendeeSchedulingHandler;
import org.bedework.calsvci.EventsI;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;

public abstract class ImplicitSchedulingHandler
extends AttendeeSchedulingHandler {
    ImplicitSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    @Override
    public ScheduleResult implicitSchedule(EventInfo ei, boolean noInvites) {
        Response resp;
        BwCalendar inbox;
        EventsI events;
        EventInfo inboxei;
        EventInfo.UpdateResult uer = ei.getUpdResult();
        uer.wasScheduled = true;
        BwEvent ev = ei.getEvent();
        boolean organizerSchedulingObject = ev.getOrganizerSchedulingObject();
        boolean attendeeSchedulingObject = ev.getAttendeeSchedulingObject();
        String orgCalAddr = ev.getSchedulingInfo().getSchedulingOwner().getCalendarAddress();
        if (!Util.isEmpty((Collection)ei.getOverrides())) {
            for (EventInfo oei : ei.getOverrides()) {
                uer = oei.getUpdResult();
                BwEvent oev = oei.getEvent();
                if (orgCalAddr == null) {
                    orgCalAddr = oev.getSchedulingInfo().getSchedulingOwner().getCalendarAddress();
                }
                if (oev.getOrganizerSchedulingObject().booleanValue()) {
                    organizerSchedulingObject = true;
                }
                if (!oev.getAttendeeSchedulingObject().booleanValue()) continue;
                attendeeSchedulingObject = true;
            }
        }
        if (!organizerSchedulingObject && !attendeeSchedulingObject) {
            if (this.debug()) {
                this.debug(String.format("Not a scheduling object: uid=\"%s\", just return", ev.getUid()));
            }
            return (ScheduleResult)Response.ok((Response)uer);
        }
        if (orgCalAddr == null) {
            return (ScheduleResult)Response.error((Response)uer, (Throwable)new BedeworkBadRequest("org.bedework.exception.missingeventproperty"));
        }
        if (ev.getOriginator() == null) {
            ev.setOriginator(orgCalAddr);
        }
        if (uer.reply) {
            int meth = ei.getReplyAttendeeURI() != null ? 6 : 3;
            ev.setScheduleMethod(meth);
            this.attendeeRespond(ei, meth, (ScheduleResult)uer);
            return uer;
        }
        if (uer.deleting) {
            if (organizerSchedulingObject) {
                ev.setScheduleMethod(5);
            } else {
                ev.setScheduleMethod(3);
            }
        } else {
            ev.setScheduleMethod(2);
        }
        if (!noInvites) {
            this.schedule(ei, ei.getReplyAttendeeURI(), uer.fromAttUri, false, (ScheduleResult)uer);
            if (!uer.isOk()) {
                return uer;
            }
        }
        if (!uer.adding && !Util.isEmpty((Collection)uer.deletedAttendees)) {
            for (BwAttendee att : uer.deletedAttendees) {
                if (Util.compareStrings((String)att.getPartstat(), (String)IcalDefs.partstats[2]) == 0) continue;
                BwEvent cncl = (BwEvent)ev.clone();
                cncl.setAttendees(null);
                cncl.addAttendee((BwAttendee)att.clone());
                cncl.setRecipients(null);
                cncl.addRecipient(att.getAttendeeUri());
                cncl.setScheduleMethod(5);
                cncl.setOrganizerSchedulingObject(Boolean.valueOf(true));
                cncl.setAttendeeSchedulingObject(Boolean.valueOf(false));
                EventInfo cei = new EventInfo(cncl);
                ScheduleResult cnclr = this.schedule(cei, null, null, false, null);
                if (!this.debug()) continue;
                this.trace(cnclr.toString());
            }
        }
        if (ei.getInboxEventName() != null && (inboxei = (events = this.getSvc().getEventsHandler()).get((inbox = this.getSvc().getCalendarsHandler().getSpecial(5, true)).getPath(), ei.getInboxEventName())) != null && !(resp = events.delete(inboxei, false)).isOk()) {
            return (ScheduleResult)Response.fromResponse((Response)uer, (Response)resp);
        }
        return uer;
    }

    public ScheduleResult sendReply(EventInfo ei, int partstat, String comment) {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        if (!ev.getAttendeeSchedulingObject().booleanValue()) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.badmethod"));
        }
        Participant att = this.findUserAttendee(ei);
        if (att == null) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.notattendee"));
        }
        BwEventObj outEv = new BwEventObj();
        EventInfo outEi = new EventInfo((BwEvent)outEv);
        SchedulingInfo outSi = outEv.getSchedulingInfo();
        Participant outAtt = outSi.copyParticipant(att);
        outAtt.setParticipationStatus(IcalDefs.partstats[partstat]);
        outAtt.setExpectReply(partstat == 0);
        outEv.setOriginator(outAtt.getCalendarAddress());
        outEv.setScheduleMethod(3);
        outEv.addRequestStatus(new BwRequestStatus(IcalDefs.requestStatusSuccess.getCode(), IcalDefs.requestStatusSuccess.getDescription()));
        SchedulingOwner evSowner = ev.getSchedulingInfo().getSchedulingOwner();
        outEv.addRecipient(evSowner.getCalendarAddress());
        outEv.updateDtstamp();
        SchedulingOwner outSowner = outSi.copySchedulingOwner(evSowner);
        outSowner.setSchedulingDtStamp(outEv.getDtstamp());
        outEv.setUid(ev.getUid());
        outEv.setRecurrenceId(ev.getRecurrenceId());
        outEv.setDtstart(ev.getDtstart());
        outEv.setDtend(ev.getDtend());
        outEv.setDuration(ev.getDuration());
        outEv.setNoStart(ev.getNoStart());
        outEv.setSummary(ev.getSummary());
        outEv.setRecurring(Boolean.valueOf(false));
        if (comment != null) {
            outEv.addComment(new BwString(null, comment));
        }
        this.scheduleResponse(outEi, sr);
        outEv.setScheduleState(1);
        return sr;
    }
}

